/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.model;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import ru.softlogic.rma.model.CartPaymentTableModel;
import ru.softlogic.rma.persistence.Record;

public class CartTableMouseListener
extends MouseAdapter {
    private JTable paymentTable;
    private JPopupMenu popupMenu;
    private JMenuItem removeMenuItem;
    private JMenuItem reprintMenuItem;

    public CartTableMouseListener(JTable paymentTable) {
        if (paymentTable == null) {
            throw new IllegalArgumentException("Need payments table");
        }
        this.paymentTable = paymentTable;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public void setRemoveMenuItem(JMenuItem removeMenuItem) {
        this.removeMenuItem = removeMenuItem;
    }

    public void setReprintMenuItem(JMenuItem reprintMenuItem) {
        this.reprintMenuItem = reprintMenuItem;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 1) {
            // empty if block
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        Record rec;
        if (event.isMetaDown() && (rec = this.getRecord(event)) != null) {
            this.removeMenuItem.putClientProperty("rec", rec);
            this.reprintMenuItem.putClientProperty("rec", rec);
            if (this.popupMenu != null) {
                this.popupMenu.show((JComponent)event.getSource(), event.getX(), event.getY());
            }
        }
    }

    private Record getRecord(MouseEvent event) {
        int row = this.paymentTable.rowAtPoint(event.getPoint());
        if (row >= 0) {
            ListSelectionModel model = this.paymentTable.getSelectionModel();
            model.setSelectionInterval(row, row);
            CartPaymentTableModel ptm = (CartPaymentTableModel)this.paymentTable.getModel();
            return ptm.getRecords()[row];
        }
        return null;
    }
}

