/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.model;

import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import rmai18n.LocBundle;
import ru.softlogic.rma.model.keeperpayments.IKeeperUpdateListener;
import ru.softlogic.rma.model.keeperpayments.PaymentData;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.utils.SumFormatter;

public class CartPaymentTableModel
implements TableModel,
IKeeperUpdateListener {
    private String[] names = new String[]{LocBundle.getMessage((String)"rma.model.paydata"), LocBundle.getMessage((String)"rma.model.paycheck"), LocBundle.getMessage((String)"rma.model.payserv"), LocBundle.getMessage((String)"rma.model.paynumb"), LocBundle.getMessage((String)"rma.model.payinput"), LocBundle.getMessage((String)"rma.model.payout"), LocBundle.getMessage((String)"rma.model.paycomm")};
    private Record[] records;
    private SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss dd.MM.yy");
    private Set<TableModelListener> listeners = new HashSet<TableModelListener>();

    public void setRecords(Record[] records) {
        this.records = records;
        for (TableModelListener l : this.listeners) {
            l.tableChanged(new TableModelEvent(this));
        }
    }

    public Record[] getRecords() {
        return this.records;
    }

    @Override
    public int getRowCount() {
        return this.records == null ? 0 : this.records.length;
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.names[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Record rec = this.records[rowIndex];
        switch (columnIndex) {
            case 0: {
                return this.sdf.format(rec.getCreated());
            }
            case 1: {
                return new Integer(rec.getDoc());
            }
            case 2: {
                return rec.getServiceName();
            }
            case 3: {
                return rec.getAccount();
            }
            case 4: {
                return SumFormatter.format(rec.getSumIncome());
            }
            case 5: {
                return SumFormatter.format(rec.getSumOutcome());
            }
            case 6: {
                return SumFormatter.format(rec.getSumComm());
            }
        }
        return LocBundle.getMessage((String)"rma.model.unknown");
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void updateState(PaymentData paymentData) {
        this.setRecords(paymentData.getToPayRecords().toArray(new Record[paymentData.getToPayRecords().size()]));
    }
}

