/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.model;

import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import rmai18n.LocBundle;
import ru.softlogic.rma.persistence.BalanceRecord;
import ru.softlogic.rma.utils.SumFormatter;

public class BalanceTableModel
implements TableModel {
    private String[] names = new String[]{"#", "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u0430", "\u0412\u0441\u0435\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439", "\u041f\u0440\u0438\u043d\u044f\u0442\u043e", "\u041f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u043e", "\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f", "\u041e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0445", "\u041e\u0442\u043c\u0435\u043d\u0451\u043d\u043d\u044b\u0445"};
    private BalanceRecord[] records;
    private Set<TableModelListener> listeners = new HashSet<TableModelListener>();

    public void setRecords(BalanceRecord[] records) {
        this.records = records;
        for (TableModelListener l : this.listeners) {
            l.tableChanged(new TableModelEvent(this));
        }
    }

    public BalanceRecord[] getRecords() {
        return this.records;
    }

    @Override
    public int getRowCount() {
        return this.records == null ? 0 : this.records.length;
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.names[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        BalanceRecord rec = this.records[rowIndex];
        switch (columnIndex) {
            case 0: {
                return new Integer(rowIndex + 1);
            }
            case 1: {
                return rec.getServiceName();
            }
            case 2: {
                return String.valueOf(rec.getCountAll());
            }
            case 3: {
                return SumFormatter.format(rec.getSumIncome());
            }
            case 4: {
                return String.format("%-4d | %-10s", rec.getCountSuccess(), SumFormatter.format(rec.getSumSuccess()));
            }
            case 5: {
                return SumFormatter.format(rec.getSumComm());
            }
            case 6: {
                return String.format("%-4d | %-10s", rec.getCountError(), SumFormatter.format(rec.getSumError()));
            }
            case 7: {
                return String.format("%-4d | %-10s", rec.getCountCancelled(), SumFormatter.format(rec.getSumCancelled()));
            }
        }
        return LocBundle.getMessage((String)"rma.model.unknown");
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }
}

