/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.mainmenu.tree;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import ru.softlogic.rma.connector.model.Menu;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.mainmenu.MainMenu;
import ru.softlogic.rma.mainmenu.MainMenuListener;
import ru.softlogic.rma.mainmenu.tree.LeafElement;
import ru.softlogic.rma.mainmenu.tree.MenuTreeModel;
import ru.softlogic.rma.mainmenu.tree.NodeElement;
import ru.softlogic.rma.mainmenu.tree.TreeMainMenuPanel;

public class TreeMainMenu
implements MainMenu {
    private TreeMainMenuPanel panel = new TreeMainMenuPanel();
    private MenuTreeModel treeModel;
    private Logger log;
    private Set<MainMenuListener> listeners = new HashSet<MainMenuListener>();
    private boolean expand;

    public TreeMainMenu() {
        this.log = Logger.getLogger((String)"app");
        this.treeModel = new MenuTreeModel();
        this.panel.getMenuTree().setModel(this.treeModel);
        this.panel.getMenuTree().addMouseListener(new LocalMouseListener());
        this.panel.getMenuTree().addKeyListener(new LocalKeyListener());
        this.panel.getMenuTree().addTreeSelectionListener(new LocalTreeSelectionListener());
        this.panel.getFilterField().getDocument().addDocumentListener(new LocalDocumentListener());
    }

    @Override
    public void setMenu(Menu menu) {
        this.treeModel.setMenu(menu);
        this.processTree();
    }

    @Override
    public void addMainMenuListener(MainMenuListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void expandTree(boolean expand) {
        this.expand = expand;
        this.processTree();
    }

    private void processTree() {
        NodeElement[] elements;
        String filter = this.panel.getFilterField().getText();
        if ((filter != null && !filter.isEmpty() || this.expand) && (elements = this.treeModel.getNodeElements()) != null) {
            for (NodeElement element : elements) {
                this.panel.getMenuTree().expandPath(new TreePath(new Object[]{"root", element}));
            }
        }
    }

    public MenuTreeModel getTreeModel() {
        return this.treeModel;
    }

    private class LocalTreeSelectionListener
    implements TreeSelectionListener {
        private LocalTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object node;
            JTree tree;
            if (e.getSource() instanceof JTree && (tree = (JTree)e.getSource()).getModel() instanceof MenuTreeModel && (node = tree.getLastSelectedPathComponent()) != null && node instanceof NodeElement) {
                NodeElement treeNode = (NodeElement)node;
                if (tree.getModel().getChildCount(treeNode) > 0) {
                    if (e.getOldLeadSelectionPath() != null && e.getOldLeadSelectionPath().getParentPath() != null && e.getOldLeadSelectionPath().getParentPath().equals(e.getNewLeadSelectionPath())) {
                        tree.setSelectionRow(tree.getSelectionRows()[0] - 1);
                    } else {
                        tree.setSelectionRow(tree.getSelectionRows()[0] + 1);
                    }
                }
            }
        }
    }

    private class LocalKeyListener
    extends KeyAdapter {
        private LocalKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TreePath tp;
            if (e.getKeyCode() == 10 && (tp = TreeMainMenu.this.panel.getMenuTree().getSelectionPath()) != null) {
                Object obj = tp.getLastPathComponent();
                MenuItem mi = null;
                if (obj instanceof LeafElement) {
                    mi = ((LeafElement)obj).getMenuItem();
                }
                for (MainMenuListener listener : TreeMainMenu.this.listeners) {
                    listener.onPayment(mi);
                }
            }
        }
    }

    private class LocalMouseListener
    extends MouseAdapter {
        private LocalMouseListener() {
        }

        @Override
        public void mouseClicked(final MouseEvent event) {
            if (event.getClickCount() == 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TreePath tp = TreeMainMenu.this.panel.getMenuTree().getClosestPathForLocation(event.getX(), event.getY());
                        if (tp != null) {
                            Object obj = tp.getLastPathComponent();
                            MenuItem mi = null;
                            if (obj instanceof LeafElement) {
                                mi = ((LeafElement)obj).getMenuItem();
                            }
                            for (MainMenuListener listener : TreeMainMenu.this.listeners) {
                                listener.onPayment(mi);
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                TreePath tp = TreeMainMenu.this.panel.getMenuTree().getClosestPathForLocation(event.getX(), event.getY());
                TreeMainMenu.this.panel.getMenuTree().setSelectionPath(tp);
                Object object = tp.getLastPathComponent();
            }
        }
    }

    private class LocalDocumentListener
    implements DocumentListener {
        private LocalDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(final DocumentEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String filter = e.getDocument().getText(0, e.getDocument().getLength());
                        TreeMainMenu.this.treeModel.setFilter(filter);
                        TreeMainMenu.this.processTree();
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

