/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.mainmenu.tree;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import ru.softlogic.rma.connector.model.Menu;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.ServiceType;
import ru.softlogic.rma.mainmenu.tree.LeafElement;
import ru.softlogic.rma.mainmenu.tree.NodeElement;

public class MenuTreeModel
implements TreeModel {
    private String filter;
    private Set<TreeModelListener> listeners;
    private Menu menu;
    private ServiceType[] serviceTypes;
    private NodeElement[] nodeElements;
    private Logger log = Logger.getLogger((String)"app");

    public MenuTreeModel() {
        this.listeners = new HashSet<TreeModelListener>();
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
        this.setFilter(this.filter);
    }

    public NodeElement[] getNodeElements() {
        return this.nodeElements;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        if (this.menu == null || this.menu.getTypes() == null || this.menu.getTypes().length == 0) {
            this.serviceTypes = null;
        } else if (filter == null || filter.isEmpty()) {
            this.serviceTypes = this.menu.getTypes();
        } else {
            filter = filter.toLowerCase();
            LinkedList<ServiceType> newList = new LinkedList<ServiceType>();
            for (ServiceType st : this.menu.getTypes()) {
                LinkedList<MenuItem> newItems = new LinkedList<MenuItem>();
                if (st.getItems() != null && st.getItems().length > 0) {
                    for (MenuItem mi : st.getItems()) {
                        String inn = mi.getService().getInn();
                        String altName = mi.getService().getAltName();
                        String rs = mi.getService().getBankRs();
                        String bik = mi.getService().getBankBik();
                        String code = String.valueOf(mi.getService().getCode());
                        String fullName = mi.getService().getFullName();
                        String bankName = mi.getService().getBankName();
                        String contractNo = mi.getService().getContractNo();
                        String kbk = mi.getService().getKbk();
                        String name = mi.getService().getName();
                        String shName = mi.getService().getShortName();
                        String kpp = mi.getService().getKpp();
                        String legal = mi.getService().getLegalName();
                        String okato = mi.getService().getOkato();
                        boolean flag = false;
                        if (mi.getService().getProperties() != null) {
                            for (String key : mi.getService().getProperties().keySet()) {
                                String value = mi.getService().getProperties().get(key);
                                if (value == null || !value.toLowerCase().contains(filter)) continue;
                                flag = true;
                                break;
                            }
                        }
                        if (!(mi.getService().getName().toLowerCase().contains(filter) || inn != null && inn.contains(filter) || altName != null && altName.toLowerCase().contains(filter) || rs != null && rs.toLowerCase().contains(filter) || bik != null && bik.toLowerCase().contains(filter) || code != null && code.toLowerCase().contains(filter) || fullName != null && fullName.toLowerCase().contains(filter) || bankName != null && bankName.toLowerCase().contains(filter) || contractNo != null && contractNo.toLowerCase().contains(filter) || kbk != null && kbk.toLowerCase().contains(filter) || name != null && name.toLowerCase().contains(filter) || shName != null && shName.toLowerCase().contains(filter) || kpp != null && kpp.toLowerCase().contains(filter) || legal != null && legal.toLowerCase().contains(filter) || okato != null && okato.toLowerCase().contains(filter)) && !flag) continue;
                        newItems.add(mi);
                    }
                }
                if (newItems.size() <= 0) continue;
                ServiceType serviceType = new ServiceType();
                serviceType.setItems(newItems.toArray(new MenuItem[newItems.size()]));
                serviceType.setLogo(st.getLogo());
                serviceType.setName(st.getName());
                newList.add(serviceType);
            }
            this.serviceTypes = newList.toArray(new ServiceType[newList.size()]);
        }
        this.nodeElements = null;
        LinkedList<NodeElement> tmpElements = new LinkedList<NodeElement>();
        if (this.serviceTypes != null) {
            for (int i = 0; i < this.serviceTypes.length; ++i) {
                if (this.serviceTypes[i].getName().startsWith("#")) continue;
                tmpElements.add(new NodeElement(this.serviceTypes[i], this.serviceTypes[i].getName()));
            }
            this.nodeElements = tmpElements.toArray(new NodeElement[tmpElements.size()]);
        }
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(new TreeModelEvent((Object)this, new TreePath("root")));
        }
    }

    @Override
    public Object getRoot() {
        return "root";
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof String) {
            return this.nodeElements[index];
        }
        if (parent instanceof NodeElement) {
            ServiceType st = ((NodeElement)parent).getServiceType();
            MenuItem mi = st.getItems()[index];
            return new LeafElement(mi, mi.getService().getName());
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof String) {
            return this.nodeElements == null ? 0 : this.nodeElements.length;
        }
        if (parent instanceof NodeElement) {
            ServiceType st = ((NodeElement)parent).getServiceType();
            return st.getItems() == null ? 0 : st.getItems().length;
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof String) {
            return false;
        }
        return !(node instanceof NodeElement);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public Menu getMenu() {
        return this.menu;
    }
}

