/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.mainmenu.hot;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ru.softlogic.rma.connector.model.Menu;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.ServiceType;
import ru.softlogic.rma.mainmenu.MainMenu;
import ru.softlogic.rma.mainmenu.MainMenuListener;
import ru.softlogic.rma.utils.ImageFactory;

public class HotKeyMenu
implements MainMenu,
ActionListener {
    private JPanel panel = new JPanel(new FlowLayout(1, 15, 10));
    private Set<MainMenuListener> listeners = new HashSet<MainMenuListener>();

    @Override
    public void setMenu(Menu menu) {
        if (menu != null && menu.getTypes() != null) {
            this.panel.setVisible(false);
            this.panel.removeAll();
            for (ServiceType st : menu.getTypes()) {
                for (MenuItem mi : st.getItems()) {
                    if (!mi.isHotKey()) continue;
                    this.panel.add(this.createButton(mi));
                }
            }
            this.panel.setVisible(true);
        }
    }

    @Override
    public void addMainMenuListener(MainMenuListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void expandTree(boolean expand) {
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    private JButton createButton(MenuItem menuItem) {
        JButton res = new JButton();
        res.setFont(new Font("tahoma", 0, 14));
        res.putClientProperty("mi", menuItem);
        res.addActionListener(this);
        Dimension size = new Dimension(120, 75);
        res.setMinimumSize(size);
        res.setMaximumSize(size);
        res.setPreferredSize(size);
        res.setHorizontalTextPosition(0);
        res.setVerticalTextPosition(3);
        Icon icon = ImageFactory.getInstance().getLogo(menuItem.getService().getLogo());
        res.setIcon(icon);
        if (icon == null) {
            res.setText("<html><p align='center'>" + menuItem.getService().getName());
        }
        return res;
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MenuItem mi = (MenuItem)((JButton)e.getSource()).getClientProperty("mi");
                for (MainMenuListener listener : HotKeyMenu.this.listeners) {
                    listener.onPayment(mi);
                }
            }
        });
    }
}

