/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.mail;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;

public class Mailer {
    private BufferedImage screen = null;
    private String logFilePuth = null;
    private String textMessage = null;
    private String hostName = null;
    private String port = null;
    private boolean needSSL = true;
    private String subject = null;
    private String from = null;
    private String[] recipients = null;
    private String login = null;
    private String password = null;
    private String logFileName;

    public void setFrom(String from) {
        this.from = from;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRecipients(String[] recipients) {
        this.recipients = recipients;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getFrom() {
        return this.from;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String[] getRecipients() {
        return this.recipients;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getLogFilePuth() {
        return this.logFilePuth;
    }

    public boolean isNeedSSL() {
        return this.needSSL;
    }

    public String getPort() {
        return this.port;
    }

    public BufferedImage getScreen() {
        return this.screen;
    }

    public String getTextMessage() {
        return this.textMessage;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setLogFilePuth(String logFilePuth) {
        this.logFilePuth = logFilePuth;
    }

    public void setNeedSSL(boolean needSSL) {
        this.needSSL = needSSL;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setScreen(BufferedImage screen) {
        this.screen = screen;
    }

    public void setTextMessage(String textMessage) {
        this.textMessage = textMessage;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public void send() throws Exception {
        String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
        Logger log = Logger.getLogger((String)"app");
        log.setAdditivity(false);
        try {
            Properties props = new Properties();
            String[] split = this.hostName.split("\\|");
            if (split.length != 4) {
                log.error((Object)(LocBundle.getMessageLog((String)"rma.mail.hostnotset") + " " + this.hostName));
                throw new Exception();
            }
            props.put("mail.smtp.host", split[0]);
            props.put("mail.smtp.auth", split[3].equals("auth:true") ? "true" : "false");
            props.put("mail.smtp.port", split[1]);
            props.put("mail.smtp.socketFactory.port", split[1]);
            props.put("mail.smtp.connectiontimeout", "20000");
            if (split[2].equals("ssl:true")) {
                props.put("mail.smtp.socketFactory.class", SSL_FACTORY);
                props.put("mail.smtp.socketFactory.fallback", "false");
            }
            Session session = split[3].equals("auth:true") ? Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(Mailer.this.getLogin(), Mailer.this.getPassword());
                }
            }) : Session.getDefaultInstance((Properties)props);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(this.from));
            InternetAddress[] addressTo = new InternetAddress[this.recipients.length];
            for (int i = 0; i < this.recipients.length; ++i) {
                addressTo[i] = new InternetAddress(this.recipients[i]);
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
            msg.setSubject(this.subject);
            MimeMultipart messCont = new MimeMultipart();
            if (this.textMessage != null) {
                MimeBodyPart messText = new MimeBodyPart();
                messText.setText(this.textMessage);
                messCont.addBodyPart((BodyPart)messText);
            }
            if (this.logFilePuth != null) {
                MimeBodyPart logFile = new MimeBodyPart();
                ByteArrayDataSource ds = new ByteArrayDataSource((InputStream)new FileInputStream(new File(this.getLogFilePuth())), "application/zip");
                logFile.setDataHandler(new DataHandler((DataSource)ds));
                logFile.setFileName(this.logFileName == null ? "logs.zip" : this.logFileName);
                messCont.addBodyPart((BodyPart)logFile);
            }
            if (this.screen != null) {
                MimeBodyPart screenFile = new MimeBodyPart();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.screen, "png", os);
                ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                ByteArrayDataSource ds = new ByteArrayDataSource((InputStream)is, "image/jpeg");
                screenFile.setDataHandler(new DataHandler((DataSource)ds));
                screenFile.setFileName("screen.png");
                messCont.addBodyPart((BodyPart)screenFile);
            }
            msg.setContent((Multipart)messCont);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }
}

