/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.connector.ws;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.input.model.NestedData;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.advanced.actions.request.Response;
import ru.softlogic.input.model.advanced.actions.request.ServerConnector;
import ru.softlogic.rma.app.config.model.Profile;
import ru.softlogic.rma.app.config.model.Proxy;
import ru.softlogic.rma.app.config.utils.KeyLoader;
import ru.softlogic.rma.app.config.utils.KeyPair;
import ru.softlogic.rma.connector.Connector;
import ru.softlogic.rma.connector.ConnectorException;
import ru.softlogic.rma.connector.ErrorListener;
import ru.softlogic.rma.connector.HeaderListener;
import ru.softlogic.rma.connector.ReferencesListener;
import ru.softlogic.rma.connector.ServerSettingsListener;
import ru.softlogic.rma.connector.model.CurrentPoint;
import ru.softlogic.rma.connector.model.CurrentUser;
import ru.softlogic.rma.connector.model.Header;
import ru.softlogic.rma.connector.model.HyperKassaPerson;
import ru.softlogic.rma.connector.model.HyperKassaTemplate;
import ru.softlogic.rma.connector.model.LoginResponse;
import ru.softlogic.rma.connector.model.NoResult;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.connector.ws.SSLSocketFactory;
import ru.softlogic.rma.connector.ws.SecurityHandler;
import ru.softlogic.rma.connector.ws.SignatureAuth;
import ru.softlogic.rma.connector.ws.stub.CommandResult;
import ru.softlogic.rma.connector.ws.stub.CommandResultRequest;
import ru.softlogic.rma.connector.ws.stub.CommandResultType;
import ru.softlogic.rma.connector.ws.stub.Demand;
import ru.softlogic.rma.connector.ws.stub.DemandRequest;
import ru.softlogic.rma.connector.ws.stub.Event;
import ru.softlogic.rma.connector.ws.stub.EventRequest;
import ru.softlogic.rma.connector.ws.stub.PD4Record;
import ru.softlogic.rma.connector.ws.stub.PD4Request;
import ru.softlogic.rma.connector.ws.stub.PackageHeader;
import ru.softlogic.rma.connector.ws.stub.Payment;
import ru.softlogic.rma.connector.ws.stub.PaymentArray;
import ru.softlogic.rma.connector.ws.stub.PaymentResponse;
import ru.softlogic.rma.connector.ws.stub.ProcessingResult;
import ru.softlogic.rma.connector.ws.stub.ReferenceResponse;
import ru.softlogic.rma.connector.ws.stub.RequestRequest;
import ru.softlogic.rma.connector.ws.stub.RequestResult;
import ru.softlogic.rma.connector.ws.stub.RmaService;
import ru.softlogic.rma.connector.ws.stub.RmaServiceService;
import ru.softlogic.rma.connector.ws.stub.Shift;
import ru.softlogic.rma.connector.ws.stub.ShiftCloseRequest;
import ru.softlogic.rma.connector.ws.stub.ShiftCloseResponse;
import ru.softlogic.rma.connector.ws.stub.ShiftCreateRequest;
import ru.softlogic.rma.connector.ws.stub.ShiftCreateResponse;
import ru.softlogic.rma.connector.ws.stub.SimpleResponse;
import ru.softlogic.rma.connector.ws.stub.State;
import ru.softlogic.rma.connector.ws.stub.VerifyRequest;
import ru.softlogic.rma.connector.ws.stub.VerifyResult;
import ru.softlogic.rma.connector.ws.stub.advanced.AdvancedResponse;
import ru.softlogic.rma.connector.ws.stub.advanced.Data;
import ru.softlogic.rma.connector.ws.stub.advanced.InputElement;
import ru.softlogic.rma.connector.ws.stub.advanced.RequestData;
import ru.softlogic.rma.model.builders.PaymentBuilder;
import ru.softlogic.rma.model.builders.ReferenceBuilder;
import ru.softlogic.rma.persistence.CloseShift;
import ru.softlogic.rma.utils.DigestUtil;
import ru.softlogic.rma.version.RmaVersion;

public class WSConnector
implements Connector,
ServerSettingsListener,
ServerConnector {
    private static final String PATH = "/rma/RmaServiceService";
    public static final int MINIMAL_REFERENCE_VERSION = 0;
    private List<ReferencesListener> referencesListeners;
    private List<HeaderListener> headerListeners;
    private List<ErrorListener> errorListeners;
    private Profile profile;
    private Proxy proxy;
    private String certPath;
    private String certPass;
    private SignatureAuth signAuth;
    private Logger log = Logger.getLogger((String)"network");

    public WSConnector() {
        this.referencesListeners = new ArrayList<ReferencesListener>();
        this.errorListeners = new ArrayList<ErrorListener>();
        this.headerListeners = new ArrayList<HeaderListener>();
    }

    public WSConnector(Profile profile, Proxy proxy, String certPath, String certPass) {
        this();
        this.proxy = proxy;
        this.profile = profile;
        this.certPath = certPath;
        this.certPass = certPass;
        KeyPair kp = KeyLoader.loadKeyPairFromProfile(profile);
        try {
            this.signAuth = new SignatureAuth(kp.getPrivateKey(), kp.getPublicKey());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public WSConnector(Profile profile, Proxy proxy, SignatureAuth auth) {
        this();
        this.profile = profile;
        this.proxy = proxy;
        this.signAuth = auth;
    }

    private RmaService getService() throws ConnectorException {
        if (this.profile == null) {
            throw new ConnectorException("No connection params");
        }
        RmaServiceService factory = new RmaServiceService();
        factory.setHandlerResolver(new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo portInfo) {
                LinkedList<Handler> handlerList = new LinkedList<Handler>();
                try {
                    handlerList.add((Handler)new SecurityHandler(WSConnector.this.signAuth));
                }
                catch (Exception ex) {
                    WSConnector.this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043b\u043e\u0433\u0435\u0440\u0430", (Throwable)ex);
                }
                return handlerList;
            }
        });
        RmaService service = factory.getRmaServicePort();
        int timeOut = this.profile.getTimeOut();
        ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", timeOut * 1000);
        ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.request.timeout", timeOut * 1000);
        if (this.proxy != null && this.proxy.isUse() && StringUtils.isNotBlank((String)this.proxy.getHost())) {
            System.setProperty("http.proxyHost", this.proxy.getHost());
            System.setProperty("https.proxyHost", this.proxy.getHost());
        } else {
            System.clearProperty("http.proxyHost");
            System.clearProperty("https.proxyHost");
        }
        if (this.proxy != null && this.proxy.isUse() && this.proxy.getPort() != null && this.proxy.getPort() > 0) {
            System.setProperty("http.proxyPort", this.proxy.getPort().toString());
            System.setProperty("https.proxyPort", this.proxy.getPort().toString());
        } else {
            System.clearProperty("http.proxyPort");
            System.clearProperty("https.proxyPort");
        }
        if (this.proxy != null && this.proxy.isUse() && this.proxy.isAuth() && StringUtils.isNotBlank((String)this.proxy.getUsername()) && StringUtils.isNotBlank((String)this.proxy.getPassword())) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(WSConnector.this.proxy.getUsername(), WSConnector.this.proxy.getPassword().toCharArray());
                }
            });
        }
        HashMap<String, List<String>> httpHeaders = new HashMap<String, List<String>>();
        httpHeaders.put("Accept-Encoding", Collections.singletonList("gzip"));
        httpHeaders.put("Content-Encoding", Collections.singletonList("gzip"));
        ((BindingProvider)service).getRequestContext().put("javax.xml.ws.http.request.headers", httpHeaders);
        try {
            if (this.certPath != null && !this.certPath.isEmpty()) {
                ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory", SSLSocketFactory.getFactory(this.certPath, this.certPass));
            } else {
                ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory", SSLSocketFactory.getSimpleFactory());
            }
            ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.hostname.verifier", SSLSocketFactory.getVerifier());
        }
        catch (SecurityException ex) {
            throw new ConnectorException(ex);
        }
        String addr = this.profile.getAddress() + PATH;
        ((BindingProvider)service).getRequestContext().put("javax.xml.ws.service.endpoint.address", addr);
        this.log.info((Object)("Try connect to: " + addr));
        return service;
    }

    public ru.softlogic.rma.connector.model.Response<LoginResponse> login(String username, String password) throws ConnectorException {
        try {
            this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0441 login");
            RmaService service = this.getService();
            PackageHeader heade = this.createHeader();
            heade.setLogin(username);
            heade.setPassword(DigestUtil.md5(password));
            Holder holder = new Holder((Object)heade);
            SimpleResponse response = service.login(0, (Holder<PackageHeader>)holder);
            LoginResponse resp = new LoginResponse();
            resp.setFio(((PackageHeader)holder.value).getFio());
            resp.setUserId(((PackageHeader)holder.value).getPerson());
            this.log.info((Object)("\u041e\u0442\u0432\u0435\u0442 \u043e\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 " + resp));
            return new ru.softlogic.rma.connector.model.Response<LoginResponse>(response.getError(), 0, resp);
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex));
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<NoResult> ping() throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.pingreq"));
        try {
            RmaService service = this.getService();
            Holder holder = new Holder((Object)this.createHeader());
            SimpleResponse result = service.ping(1, (Holder<PackageHeader>)holder);
            this.notifyError(result.getError(), null);
            this.notifyHeader(this.convertHolderToHeader((Holder<PackageHeader>)holder));
            return new ru.softlogic.rma.connector.model.Response<NoResult>(result.getError());
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex));
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<References> references(long currentVersion) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.refreq"));
        try {
            RmaService service = this.getService();
            Holder holder = new Holder((Object)this.createHeader());
            ((PackageHeader)holder.value).setRv(currentVersion);
            ReferenceResponse result = service.referencesNew(0, (Holder<PackageHeader>)holder);
            this.notifyError(result.getError(), null);
            this.notifyHeader(this.convertHolderToHeader((Holder<PackageHeader>)holder));
            if (result.getError() == 0) {
                References ref = new ReferenceBuilder().build(result);
                this.notifyReferences(ref);
                return new ru.softlogic.rma.connector.model.Response<References>(result.getError(), 0, ref);
            }
            return new ru.softlogic.rma.connector.model.Response<References>(result.getError());
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex));
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<List<ru.softlogic.rma.connector.model.State>> payment(ru.softlogic.rma.connector.model.Payment[] payments) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.payreq"));
        RmaService service = this.getService();
        try {
            Holder holder = new Holder((Object)this.createHeader());
            PaymentArray pa = new PaymentArray();
            for (ru.softlogic.rma.connector.model.Payment payment : payments) {
                Payment p = PaymentBuilder.createPayment(payment);
                if (payment.getState() == 80) {
                    p.setState((short)80);
                }
                p.setForm(payment.getForm());
                if (payment.getIdShift() > 0L) {
                    p.setShiftId((int)payment.getIdShift());
                }
                pa.getItem().add(p);
            }
            PaymentResponse result = service.payment(pa, (Holder<PackageHeader>)holder);
            ArrayList<ru.softlogic.rma.connector.model.State> states = new ArrayList<ru.softlogic.rma.connector.model.State>(result.getStates().size());
            for (State state : result.getStates()) {
                ru.softlogic.rma.connector.model.State s = new ru.softlogic.rma.connector.model.State();
                s.setId(state.getId());
                s.setError(state.getError());
                s.setFinalStatus(state.getFinalStatus());
                s.setState(state.getState());
                s.setSubstate(state.getSubstate());
                s.setExtId(state.getExtId());
                s.setAbsState(state.getAbsState());
                states.add(s);
            }
            this.notifyError(result.getError(), null);
            this.notifyHeader(this.convertHolderToHeader((Holder<PackageHeader>)holder));
            return new ru.softlogic.rma.connector.model.Response<List<ru.softlogic.rma.connector.model.State>>(result.getError(), 0, states);
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<ProcessingResult> opayment(ru.softlogic.rma.connector.model.Payment payment) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.payreq"));
        RmaService service = this.getService();
        try {
            Holder holder = new Holder((Object)this.createHeader());
            ((PackageHeader)holder.value).setPerson(payment.getIdUser());
            ProcessingResult result = service.opayment(PaymentBuilder.createPayment(payment), (Holder<PackageHeader>)holder);
            this.notifyError(result.getError(), null);
            this.notifyHeader(this.convertHolderToHeader((Holder<PackageHeader>)holder));
            return new ru.softlogic.rma.connector.model.Response<ProcessingResult>(result.getError(), 0, result);
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<List<ru.softlogic.rma.connector.model.State>> status(ru.softlogic.rma.connector.model.Payment[] payments) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.statreq"));
        RmaService service = this.getService();
        try {
            Holder holder = new Holder((Object)this.createHeader());
            PaymentArray pa = new PaymentArray();
            for (ru.softlogic.rma.connector.model.Payment payment : payments) {
                Payment p = new Payment();
                p.setAccount(payment.getAccount());
                p.setCommission(payment.getCommission());
                p.setCreated(payment.getCreated());
                p.setDoc(payment.getDoc());
                p.setId((int)payment.getId());
                p.setPid(payment.getPid());
                p.setService(payment.getService());
                p.setSumComm(payment.getSumComm());
                p.setSumIncome(payment.getSumIncome());
                p.setSumOutcome(payment.getSumOutcome());
                p.setSumFee(payment.getSumFee());
                p.setPerson(payment.getIdUser());
                pa.getItem().add(PaymentBuilder.createPayment(payment));
            }
            PaymentResponse result = service.status(pa, (Holder<PackageHeader>)holder);
            ArrayList<ru.softlogic.rma.connector.model.State> states = new ArrayList<ru.softlogic.rma.connector.model.State>(result.getStates().size());
            for (State state : result.getStates()) {
                ru.softlogic.rma.connector.model.State s = new ru.softlogic.rma.connector.model.State();
                s.setId(state.getId());
                s.setError(state.getError());
                s.setFinalStatus(state.getFinalStatus());
                s.setState(state.getState());
                s.setSubstate(state.getSubstate());
                s.setExtId(state.getExtId());
                s.setAbsState(state.getAbsState());
                states.add(s);
            }
            this.notifyError(result.getError(), null);
            this.notifyHeader(this.convertHolderToHeader((Holder<PackageHeader>)holder));
            return new ru.softlogic.rma.connector.model.Response<List<ru.softlogic.rma.connector.model.State>>(result.getError(), 0, states);
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<NoResult> events(ru.softlogic.rma.connector.model.Event[] events) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.evntreq"));
        RmaService service = this.getService();
        try {
            Holder holder = new Holder((Object)this.createHeader());
            EventRequest er = new EventRequest();
            Event[] es = new Event[events.length];
            int i = 0;
            for (ru.softlogic.rma.connector.model.Event event : events) {
                Event e = new Event(event.getType(), event.getDate(), event.getComment());
                es[i++] = e;
            }
            er.setEvents(es);
            SimpleResponse result = service.events(er, (Holder<PackageHeader>)holder);
            this.notifyError(result.getError(), null);
            this.notifyHeader(this.convertHolderToHeader((Holder<PackageHeader>)holder));
            return new ru.softlogic.rma.connector.model.Response<NoResult>(result.getError());
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<NoResult> commandResults(ru.softlogic.rma.connector.model.command.CommandResult[] results) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.evntreq"));
        RmaService service = this.getService();
        try {
            Holder holder = new Holder((Object)this.createHeader());
            CommandResultRequest crr = new CommandResultRequest();
            CommandResult[] cr = new CommandResult[results.length];
            int i = 0;
            for (ru.softlogic.rma.connector.model.command.CommandResult result : results) {
                CommandResult c = new CommandResult(result.getId(), CommandResultType.valueOf(result.getResultType().name()), result.getComment());
                cr[i++] = c;
            }
            crr.setCommands(cr);
            SimpleResponse result = service.commands(crr, (Holder<PackageHeader>)holder);
            this.notifyError(result.getError(), null);
            this.notifyHeader(this.convertHolderToHeader((Holder<PackageHeader>)holder));
            return new ru.softlogic.rma.connector.model.Response<NoResult>(result.getError());
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<ru.softlogic.rma.connector.model.State> cancel(ru.softlogic.rma.connector.model.Payment payment) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.cancelreq"));
        RmaService service = this.getService();
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            Payment p = new Payment();
            p.setAccount(payment.getAccount());
            p.setCommission(payment.getCommission());
            p.setCreated(payment.getCreated());
            p.setDoc(payment.getDoc());
            p.setId((int)payment.getId());
            p.setPid(payment.getPid());
            p.setService(payment.getService());
            p.setSumComm(payment.getSumComm());
            p.setSumIncome(payment.getSumIncome());
            p.setSumOutcome(payment.getSumOutcome());
            PaymentResponse result = service.cancel(p, (Holder<PackageHeader>)holder);
            ru.softlogic.rma.connector.model.State s = null;
            if (result.getStates() != null && !result.getStates().isEmpty()) {
                State state = result.getStates().get(0);
                s = new ru.softlogic.rma.connector.model.State();
                s.setId(state.getId());
                s.setError(state.getError());
                s.setFinalStatus(state.getFinalStatus());
                s.setState(state.getState());
                s.setSubstate(state.getSubstate());
                s.setExtId(state.getExtId());
                s.setAbsState(state.getAbsState());
            }
            int serverError = result.getError() > 10 ? 0 : result.getError();
            int serviceError = result.getError() > 10 ? result.getError() : 0;
            this.notifyError(serverError, null);
            this.notifyHeader(this.convertHolderToHeader((Holder<PackageHeader>)holder));
            return new ru.softlogic.rma.connector.model.Response<ru.softlogic.rma.connector.model.State>(serverError, serviceError, s);
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<VerifyResult> verify(int idService, Map<String, String> form) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.conector.verifyreq"));
        RmaService service = this.getService();
        try {
            Holder holder = new Holder((Object)this.createHeader());
            VerifyRequest vr = new VerifyRequest();
            vr.setSid(idService);
            VerifyRequest.Form f = new VerifyRequest.Form();
            for (String key : form.keySet()) {
                VerifyRequest.Form.Entry entry = new VerifyRequest.Form.Entry();
                entry.setKey(key);
                entry.setValue(form.get(key));
                f.getEntry().add(entry);
            }
            vr.setForm(f);
            VerifyResult result = service.verify(vr, (Holder<PackageHeader>)holder);
            this.notifyError(result.getError(), null);
            this.notifyHeader(this.convertHolderToHeader((Holder<PackageHeader>)holder));
            return new ru.softlogic.rma.connector.model.Response<VerifyResult>(result.getError(), 0, result);
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<NoResult> demand(ru.softlogic.rma.connector.model.Demand[] demands) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.demandreq"));
        RmaService service = this.getService();
        try {
            Holder holder = new Holder((Object)this.createHeader());
            DemandRequest er = new DemandRequest();
            Demand[] es = new Demand[demands.length];
            int i = 0;
            for (ru.softlogic.rma.connector.model.Demand demand : demands) {
                Demand e = new Demand(demand.getId(), demand.getIdService(), demand.getText());
                es[i++] = e;
            }
            er.setDemands(es);
            SimpleResponse result = service.demand(er, (Holder<PackageHeader>)holder);
            this.notifyError(result.getError(), null);
            this.notifyHeader(this.convertHolderToHeader((Holder<PackageHeader>)holder));
            return new ru.softlogic.rma.connector.model.Response<NoResult>(result.getError());
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    public ru.softlogic.rma.connector.model.Response<RequestResult> orequest(short sid, Map<String, String> form) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.oreqreq"));
        RmaService service = this.getService();
        try {
            Holder holder = new Holder((Object)this.createHeader());
            RequestRequest vr = new RequestRequest();
            vr.setId(sid);
            RequestRequest.Form f = new RequestRequest.Form();
            for (String key : form.keySet()) {
                RequestRequest.Form.Entry entry = new RequestRequest.Form.Entry();
                entry.setKey(key);
                entry.setValue(form.get(key));
                f.getEntry().add(entry);
            }
            vr.setForm(f);
            RequestResult result = service.orequest(vr, (Holder<PackageHeader>)holder);
            this.notifyError(result.getError(), null);
            this.notifyHeader(this.convertHolderToHeader((Holder<PackageHeader>)holder));
            return new ru.softlogic.rma.connector.model.Response<RequestResult>(result.getError(), result.getRerror(), result);
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    public Response<ru.softlogic.input.model.Data> request(ru.softlogic.input.model.advanced.actions.request.RequestData data) throws ru.softlogic.input.model.advanced.actions.request.ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.areqreq"));
        try {
            RmaService service = this.getService();
            Holder holder = new Holder((Object)this.createHeader());
            RequestData rd = new RequestData();
            rd.setServiceId(data.getIdService());
            rd.setParams(data.getParams());
            rd.setFunction(data.getFunction());
            rd.setProviderId(data.getIdProvider());
            AdvancedResponse result = service.arequest(rd, (Holder<PackageHeader>)holder);
            this.notifyError(result.getServerError(), null);
            this.notifyHeader(this.convertHolderToHeader((Holder<PackageHeader>)holder));
            ru.softlogic.input.model.Data dest = null;
            if (result.getData() != null) {
                dest = new ru.softlogic.input.model.Data();
                this.fillData(dest, result.getData());
            }
            return new Response(result.getServerError(), result.getServiceError(), (Object)dest);
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ru.softlogic.input.model.advanced.actions.request.ConnectorException((Throwable)ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ru.softlogic.input.model.advanced.actions.request.ConnectorException((Throwable)ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ru.softlogic.input.model.advanced.actions.request.ConnectorException((Throwable)ex);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<Boolean> hyperReg(short sid, HyperKassaPerson person) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.hreqreq"));
        HashMap<String, String> form = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
        form.put("function", "reg");
        form.put("mPhone", person.getmPhone());
        form.put("Fam", person.getFam());
        form.put("Name", person.getName());
        form.put("SName", person.getSname());
        form.put("KD", person.getKd());
        form.put("SD", person.getSd());
        form.put("ND", person.getNd());
        form.put("GD", person.getGd());
        form.put("DD", sdf.format(person.getDd()));
        form.put("DR", sdf.format(person.getDr()));
        form.put("MR", person.getMr());
        form.put("CS", person.getCs());
        form.put("AMR", person.getAmr());
        form.put("id1", "1");
        ru.softlogic.rma.connector.model.Response<RequestResult> resp = this.orequest(sid, form);
        Boolean res = false;
        if (resp.getServerError() == 0 && resp.getServiceError() == 0) {
            res = true;
        }
        return new ru.softlogic.rma.connector.model.Response<Boolean>(resp.getServerError(), resp.getServiceError(), res);
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<String> hyperRegTemplate(short sid, HyperKassaTemplate template) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.htreqreq"));
        HashMap<String, String> form = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
        form.put("function", "check");
        form.put("mPhone", template.getmPhone());
        form.put("RCode", "601");
        form.put("id1", "1");
        form.put("Params", template.getBik() + ";" + template.getAccount() + ";" + template.getFio() + (template.getNumber() != null && !template.getNumber().isEmpty() ? ";" + template.getNumber() : ""));
        ru.softlogic.rma.connector.model.Response<RequestResult> resp = this.orequest(sid, form);
        String res = null;
        if (resp.getServiceError() == 0 && resp.getServerError() == 0) {
            for (RequestResult.Data.Entry entry : resp.getResult().getData().getEntry()) {
                if (!entry.getKey().equals("Tid")) continue;
                res = entry.getValue().substring(13, 23);
            }
        }
        return new ru.softlogic.rma.connector.model.Response<Object>(resp.getServerError(), resp.getServiceError(), res);
    }

    private void notifyReferences(References references) {
        for (ReferencesListener referencesListener : this.referencesListeners) {
            referencesListener.onReferences(references);
        }
    }

    private void notifyError(Integer error, Exception e) {
        for (ErrorListener listener : this.errorListeners) {
            if (error != null) {
                listener.update(error);
            }
            listener.update(e);
        }
    }

    private void notifyHeader(Header header) {
        for (HeaderListener listener : this.headerListeners) {
            listener.onHeader(header);
        }
    }

    private PackageHeader createHeader() {
        PackageHeader header = new PackageHeader();
        header.setRv(0L);
        header.setS(0);
        header.setSoftVersion(RmaVersion.getVersion());
        header.setJavaVersion(System.getProperty("java.version") + "/" + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        header.setPoint(CurrentPoint.getInstance().getProfile().getPointId());
        return header;
    }

    private void fillData(ru.softlogic.input.model.Data dest, Data source) {
        dest.setElements(new LinkedList());
        if (source.getElements() != null) {
            for (InputElement ie : source.getElements()) {
                ru.softlogic.input.model.InputElement element = new ru.softlogic.input.model.InputElement(ie.getKey(), ie.getKeyTitle(), ie.getValue(), ie.getValueTitle(), ie.getFlags() != null ? ie.getFlags() : 0);
                dest.getElements().add(element);
            }
        }
        if (source.getSum() != null) {
            dest.setSum(new TransactionSum(source.getSum().getSum()));
        }
        if (source.getData() != null) {
            NestedData nd = new NestedData();
            nd.setId(source.getData().getId());
            nd.setData(new LinkedList());
            for (Data newSource : source.getData().getData()) {
                ru.softlogic.input.model.Data newDest = new ru.softlogic.input.model.Data();
                this.fillData(newDest, newSource);
                nd.getData().add(newDest);
            }
            dest.setNestedData(nd);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<NoResult> sendPD4(ru.softlogic.rma.model.add.PD4Record[] records) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.pd4req"));
        RmaService service = this.getService();
        try {
            Holder holder = new Holder((Object)this.createHeader());
            PD4Request er = new PD4Request();
            PD4Record[] es = new PD4Record[records.length];
            int i = 0;
            for (ru.softlogic.rma.model.add.PD4Record c : records) {
                PD4Record record = new PD4Record();
                record.setBank(c.getBank());
                record.setBankKs(c.getBankKs());
                record.setBik(c.getBik());
                record.setDestination(c.getDestination());
                record.setInn(c.getInn());
                record.setKbk(c.getKbk());
                record.setKpp(c.getKpp());
                record.setName(c.getName());
                record.setOkato(c.getOkato());
                record.setRs(c.getRs());
                es[i++] = record;
            }
            er.setRecords(es);
            SimpleResponse result = service.pd4(er, (Holder<PackageHeader>)holder);
            this.notifyError(result.getError(), null);
            this.notifyHeader(this.convertHolderToHeader((Holder<PackageHeader>)holder));
            return new ru.softlogic.rma.connector.model.Response<NoResult>(result.getError());
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<ru.softlogic.rma.connector.model.State> annul(ru.softlogic.rma.connector.model.Payment payment) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.cancelreq"));
        RmaService service = this.getService();
        try {
            PackageHeader header = this.createHeader();
            header.setPerson(payment.getIdUser());
            Holder holder = new Holder((Object)header);
            Payment p = new Payment();
            p.setAccount(payment.getAccount());
            p.setCommission(payment.getCommission());
            p.setCreated(payment.getCreated());
            p.setDoc(payment.getDoc());
            p.setId((int)payment.getId());
            p.setPid(payment.getPid());
            p.setService(payment.getService());
            p.setSumComm(payment.getSumComm());
            p.setSumIncome(payment.getSumIncome());
            p.setSumOutcome(payment.getSumOutcome());
            p.setPerson(payment.getIdUser());
            PaymentResponse result = service.annul(p, (Holder<PackageHeader>)holder);
            ru.softlogic.rma.connector.model.State s = null;
            if (result.getStates() != null && !result.getStates().isEmpty()) {
                State state = result.getStates().get(0);
                s = new ru.softlogic.rma.connector.model.State();
                s.setId(state.getId());
                s.setError(state.getError());
                s.setFinalStatus(state.getFinalStatus());
                s.setState(state.getState());
                s.setSubstate(state.getSubstate());
                s.setExtId(state.getExtId());
                s.setAbsState(state.getAbsState());
            }
            int serverError = result.getError() > 10 ? 0 : result.getError();
            int serviceError = result.getError() > 10 ? result.getError() : 0;
            this.notifyError(serverError, null);
            this.notifyHeader(new Header(((PackageHeader)holder.value).getRv(), ((PackageHeader)holder.value).getS(), ((PackageHeader)holder.value).getB(), ((PackageHeader)holder.value).getServerDate(), ((PackageHeader)holder.value).getFio(), ((PackageHeader)holder.value).getChangepwd()));
            return new ru.softlogic.rma.connector.model.Response<ru.softlogic.rma.connector.model.State>(serverError, serviceError, s);
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<NoResult> changePassword(String newPassword) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.changepassword"));
        RmaService service = this.getService();
        try {
            Holder holder = new Holder((Object)this.createHeader());
            SimpleResponse result = service.changePassword(newPassword, (Holder<PackageHeader>)holder);
            this.notifyError(result.getError(), null);
            this.notifyHeader(new Header(((PackageHeader)holder.value).getRv(), ((PackageHeader)holder.value).getS(), ((PackageHeader)holder.value).getB(), ((PackageHeader)holder.value).getServerDate(), ((PackageHeader)holder.value).getFio(), null));
            return new ru.softlogic.rma.connector.model.Response<NoResult>(result.getError());
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ru.softlogic.rma.connector.model.Response<NoResult> changeAttributes(ru.softlogic.rma.connector.model.Payment payment) throws ConnectorException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.connector.changereq"));
        RmaService service = this.getService();
        try {
            Holder holder = new Holder((Object)this.createHeader());
            Payment p = new Payment();
            p.setAccount(payment.getAccount());
            p.setCommission(payment.getCommission());
            p.setCreated(payment.getCreated());
            p.setDoc(payment.getDoc());
            p.setId((int)payment.getId());
            p.setPid(payment.getPid());
            p.setService(payment.getService());
            p.setSumComm(payment.getSumComm());
            p.setSumIncome(payment.getSumIncome());
            p.setSumOutcome(payment.getSumOutcome());
            p.setForm(payment.getForm());
            SimpleResponse result = service.changeAttributes(p, (Holder<PackageHeader>)holder);
            int serverError = result.getError() > 10 ? 0 : result.getError();
            int serviceError = result.getError() > 10 ? result.getError() : 0;
            this.notifyError(serverError, null);
            this.notifyHeader(new Header(((PackageHeader)holder.value).getRv(), ((PackageHeader)holder.value).getS(), ((PackageHeader)holder.value).getB(), ((PackageHeader)holder.value).getServerDate(), ((PackageHeader)holder.value).getFio(), ((PackageHeader)holder.value).getChangepwd()));
            return new ru.softlogic.rma.connector.model.Response<NoResult>(serverError, serviceError);
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
    }

    public ru.softlogic.rma.connector.model.Response<ru.softlogic.rma.connector.model.Shift> openShift(short num, String typeCode, Date startTime, Date endTime) throws ConnectorException {
        ru.softlogic.rma.connector.model.Response<ru.softlogic.rma.connector.model.Shift> result = null;
        ru.softlogic.rma.connector.model.Shift shift = null;
        RmaService service = this.getService();
        try {
            Holder holder = new Holder((Object)this.createHeader());
            ((PackageHeader)holder.value).setPerson(CurrentUser.getInstance().getUserId());
            ShiftCreateRequest req = new ShiftCreateRequest();
            req.setComment("");
            req.setStart(startTime);
            req.setEnd(endTime);
            req.setShiftTypeCode(typeCode);
            req.setPerson(CurrentUser.getInstance().getUserId());
            req.setNum(num);
            ShiftCreateResponse resp = service.createShift(req, (Holder<PackageHeader>)holder);
            if (resp.getShift() != null) {
                shift = new ru.softlogic.rma.connector.model.Shift();
                Shift recieveShift = resp.getShift();
                shift.setComment(recieveShift.getComment());
                shift.setDayBegin(recieveShift.getStart());
                shift.setDayEnd(recieveShift.getEnd());
                shift.setIdServer(recieveShift.getId());
                shift.setNum(num);
                shift.setStatus((short)0);
                shift.setOperatingDay(recieveShift.getOperatingDayName());
                shift.setIdPersonOpen(recieveShift.getPersonOpen());
                shift.setFioPersonOpen(recieveShift.getPersonOpenName());
                shift.setShiftTypeCode(recieveShift.getType());
                shift.setOperationDayId(recieveShift.getOperatingDay());
            }
            result = new ru.softlogic.rma.connector.model.Response<ru.softlogic.rma.connector.model.Shift>(0, resp.getError(), shift);
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
        return result;
    }

    public ru.softlogic.rma.connector.model.Response<NoResult> closeShift(CloseShift clShReq) throws ConnectorException {
        ru.softlogic.rma.connector.model.Response<NoResult> result = null;
        Object shift = null;
        RmaService service = this.getService();
        try {
            Holder holder = new Holder((Object)this.createHeader());
            ShiftCloseRequest shiftCloseRequest = new ShiftCloseRequest();
            shiftCloseRequest.setShiftId(clShReq.getShiftId());
            shiftCloseRequest.setEnd(clShReq.getCloseTime());
            shiftCloseRequest.setPerson(clShReq.getIdPersonCreate());
            shiftCloseRequest.setComment("\u0422\u0435\u0441\u0442 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u043c\u0435\u043d\u044b");
            ShiftCloseResponse response = service.closeShift(shiftCloseRequest, (Holder<PackageHeader>)holder);
            result = new ru.softlogic.rma.connector.model.Response<NoResult>(0, response.getError());
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.notifyError(null, (Exception)((Object)ex));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)("Other error: " + ex), (Throwable)ex);
            this.notifyError(null, ex);
            throw new ConnectorException(ex);
        }
        return result;
    }

    public Header convertHolderToHeader(Holder<PackageHeader> holder) {
        return new Header(((PackageHeader)holder.value).getRv(), ((PackageHeader)holder.value).getS(), ((PackageHeader)holder.value).getB(), ((PackageHeader)holder.value).getServerDate(), ((PackageHeader)holder.value).getFio(), ((PackageHeader)holder.value).getChangepwd());
    }

    @Override
    public void onProxyChange(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public void onServerChange(Profile newProfile) {
        this.profile = newProfile;
    }

    @Override
    public boolean addReferenceListener(ReferencesListener listener) {
        return this.referencesListeners.add(listener);
    }

    @Override
    public boolean addHeaderListener(HeaderListener listener) {
        return this.headerListeners.add(listener);
    }

    @Override
    public boolean addErrorListener(ErrorListener listener) {
        return this.errorListeners.add(listener);
    }
}

