/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.connector.ws;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class LoggerMessageHeader
implements SOAPHandler<SOAPMessageContext> {
    Logger log;
    private static final Pattern pattern = Pattern.compile("(login=\".*rv)");

    public LoggerMessageHeader(Logger log) {
        this.log = log;
    }

    public Set<QName> getHeaders() {
        QName securityHeader = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse");
        HashSet<QName> headers = new HashSet<QName>();
        headers.add(securityHeader);
        return headers;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        SOAPMessage msg = context.getMessage();
        if (outbound) {
            return this.processOutputMessage(msg);
        }
        return this.processInputMessage(msg);
    }

    public boolean handleFault(SOAPMessageContext context) {
        try {
            this.processFault(context.getMessage());
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        return true;
    }

    private boolean processFault(SOAPMessage msg) {
        this.log.info((Object)("\u043e\u0448\u0438\u0431\u043a\u0430 soap: " + WSUtils.nodeToString((Node)msg.getSOAPPart())));
        return true;
    }

    private boolean processOutputMessage(SOAPMessage msg) {
        this.log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0441: " + WSUtils.nodeToString((Node)msg.getSOAPPart())));
        return true;
    }

    private boolean processInputMessage(SOAPMessage msg) {
        this.log.info((Object)("\u041e\u0442\u0432\u0435\u0442: " + WSUtils.nodeToString((Node)msg.getSOAPPart())));
        return true;
    }

    public void close(MessageContext context) {
    }

    public String nodeToString(SOAPMessage message) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            message.writeTo((OutputStream)baos);
            baos.close();
            return baos.toString();
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            return "";
        }
    }

    public static class WSUtils {
        public static final String cpw = "QZt64WK8Vdxq";

        static String nodeToString(Node node) {
            try {
                TransformerFactory tfactory = TransformerFactory.newInstance();
                Transformer trans = null;
                trans = tfactory.newTransformer();
                trans.setOutputProperty("indent", "yes");
                trans.setOutputProperty("encoding", "utf8");
                DOMSource source = new DOMSource(node);
                StringWriter writer = new StringWriter();
                StreamResult res = new StreamResult(writer);
                trans.transform(source, res);
                String strLog = writer.toString();
                Matcher matcher = pattern.matcher(strLog);
                if (matcher.find()) {
                    String login = matcher.group(0);
                    strLog = strLog.replace(login, "rv");
                }
                return strLog;
            }
            catch (TransformerException ex) {
                return "";
            }
        }
    }
}

