/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.connector.model;

import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.softlogic.rma.connector.model.Dealer;
import ru.softlogic.rma.connector.model.Menu;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.OperatingDay;
import ru.softlogic.rma.connector.model.Operator;
import ru.softlogic.rma.connector.model.Person;
import ru.softlogic.rma.connector.model.PersonalNumber;
import ru.softlogic.rma.connector.model.Point;
import ru.softlogic.rma.connector.model.ServiceType;
import ru.softlogic.rma.connector.model.command.Auth;
import ru.softlogic.rma.connector.model.command.Command;
import ru.softlogic.rma.connector.model.directory.calendar.SheduleReference;
import ru.softlogic.rma.connector.model.directory.shift.ShiftTypesReference;
import ru.softlogic.rma.model.add.PD4Record;

public class References
implements Serializable {
    private static final long serialVersionUID = -8763630901894280627L;
    private long version;
    private Dealer dealer;
    private Point point;
    private Menu menu;
    private Operator operator;
    private PersonalNumber[] personalNumbers;
    private String software;
    private String updateUrl;
    private String updateLogin;
    private String updatePassword;
    protected Command[] commands;
    protected Auth auth;
    protected PD4Record[] pd4Records;
    private SheduleReference sheduleReference;
    private ShiftTypesReference shiftTypeReference;
    private OperatingDay operatingDay;
    private List<Person> persons;
    private List<MenuItem> changes;
    private Map<String, BitSet> rolePrivileges = new HashMap<String, BitSet>();

    public References() {
        BitSet bitSet = new BitSet(32);
        bitSet.set(0);
        this.rolePrivileges.put("KASSIR", bitSet);
    }

    public void mergeMenuChanges() {
        if (this.changes != null && !this.changes.isEmpty() && this.menu != null && this.menu.getTypes() != null && this.menu.getTypes().length > 0) {
            block0: for (ServiceType eachType : this.menu.getTypes()) {
                if (this.changes.isEmpty()) break;
                if (eachType.getItems() == null) continue;
                MenuItem[] items = eachType.getItems();
                for (int index = 0; index < items.length; ++index) {
                    int idx = this.changes.indexOf(items[index]);
                    MenuItem newItem = this.changes.remove(idx);
                    newItem.setServiceType(items[index].getServiceType());
                    items[index] = newItem;
                    if (this.changes.isEmpty()) continue block0;
                }
            }
        }
    }

    public Map<String, PersonalNumber> getPersonalNumbersAsMap() {
        HashMap<String, PersonalNumber> map = new HashMap<String, PersonalNumber>();
        if (this.personalNumbers != null) {
            for (PersonalNumber pn : this.personalNumbers) {
                map.put(pn.getNumber(), pn);
            }
        }
        return map;
    }

    public Person getPersonById(short id) {
        for (Person each : this.persons) {
            if (each.getIdPerson() != id) continue;
            return each;
        }
        return null;
    }

    public Map<String, BitSet> getRolePrivileges() {
        return this.rolePrivileges;
    }

    public void setRolePrivileges(Map<String, BitSet> rolePrivileges) {
        this.rolePrivileges = rolePrivileges;
    }

    public List<MenuItem> getChanges() {
        return this.changes;
    }

    public void setChanges(List<MenuItem> changes) {
        this.changes = changes;
    }

    public OperatingDay getOperatingDay() {
        return this.operatingDay;
    }

    public void setOperatingDay(OperatingDay operatingDay) {
        this.operatingDay = operatingDay;
    }

    public List<Person> getPersons() {
        return this.persons;
    }

    public void setPersons(List<Person> persons) {
        this.persons = persons;
    }

    public SheduleReference getSheduleReference() {
        return this.sheduleReference;
    }

    public void setSheduleReference(SheduleReference sheduleReference) {
        this.sheduleReference = sheduleReference;
    }

    public ShiftTypesReference getShiftTypeReference() {
        return this.shiftTypeReference;
    }

    public void setShiftTypeReference(ShiftTypesReference shiftTypeReference) {
        this.shiftTypeReference = shiftTypeReference;
    }

    public Dealer getDealer() {
        return this.dealer;
    }

    public void setDealer(Dealer dealer) {
        this.dealer = dealer;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public PersonalNumber[] getPersonalNumbers() {
        return this.personalNumbers;
    }

    public void setPersonalNumbers(PersonalNumber[] personalNumbers) {
        this.personalNumbers = personalNumbers;
    }

    public Point getPoint() {
        return this.point;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String getSoftware() {
        return this.software;
    }

    public void setSoftware(String software) {
        this.software = software;
    }

    public String getUpdateLogin() {
        return this.updateLogin;
    }

    public void setUpdateLogin(String updateLogin) {
        this.updateLogin = updateLogin;
    }

    public String getUpdatePassword() {
        return this.updatePassword;
    }

    public void setUpdatePassword(String updatePassword) {
        this.updatePassword = updatePassword;
    }

    public String getUpdateUrl() {
        return this.updateUrl;
    }

    public void setUpdateUrl(String updateUrl) {
        this.updateUrl = updateUrl;
    }

    public Auth getAuth() {
        return this.auth;
    }

    public void setAuth(Auth auth) {
        this.auth = auth;
    }

    public Command[] getCommands() {
        return this.commands;
    }

    public void setCommands(Command[] commands) {
        this.commands = commands;
    }

    public PD4Record[] getPd4Records() {
        return this.pd4Records;
    }

    public void setPd4Records(PD4Record[] pd4Records) {
        this.pd4Records = pd4Records;
    }
}

