/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.connector.model;

import java.io.Serializable;
import java.util.Date;

public class Event
implements Serializable {
    public static final short START = 1;
    public static final short SOFTWARE_ERROR = 2;
    private short type;
    private Date date;
    private String comment;

    public Event() {
    }

    public Event(short type) {
        this(type, null);
    }

    public Event(short type, String comment) {
        if (type == 0) {
            throw new IllegalArgumentException("Need the type");
        }
        this.type = type;
        this.comment = comment;
        this.date = new Date();
    }

    public String getComment() {
        return this.comment;
    }

    public Date getDate() {
        return this.date;
    }

    public short getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        if (this.type != other.type) {
            return false;
        }
        return this.date == other.date || this.date != null && this.date.equals(other.date);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (this.date != null ? this.date.hashCode() : 0);
        hash = 19 * hash + (this.comment != null ? this.comment.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.getClass().getName() + "[type=" + this.type + ", date=" + this.date + ", comment=" + this.comment + "]";
    }
}

