/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.app.helpers;

import java.awt.EventQueue;
import java.util.concurrent.ExecutorService;
import javax.swing.JFrame;
import ru.softlogic.rma.RmaWaitBox;
import ru.softlogic.rma.app.helpers.Task;

public class TaskExecutor {
    private JFrame frame;
    private RmaWaitBox waitBox;
    private ExecutorService executorService;

    public TaskExecutor(JFrame frame, ExecutorService executorService) {
        if (frame == null) {
            throw new IllegalArgumentException("Need JFrame");
        }
        this.frame = frame;
        this.waitBox = new RmaWaitBox(frame);
        this.waitBox.setAlwaysOnTop(true);
        this.executorService = executorService;
    }

    public void execute(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("Need Task");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskExecutor.this.waitBox.setLocationRelativeTo(TaskExecutor.this.frame);
                TaskExecutor.this.waitBox.setVisible(true);
            }
        });
        this.executorService.submit(new ExecutorThread(task));
    }

    private class ResultRunnable
    implements Runnable {
        private Object result;
        private Task task;

        public ResultRunnable(Object result, Task task) {
            this.result = result;
            this.task = task;
        }

        @Override
        public void run() {
            this.task.onResult(this.result);
        }
    }

    private class ExecutorThread
    implements Runnable {
        private Task task;

        public ExecutorThread(Task task) {
            this.task = task;
        }

        @Override
        public void run() {
            Object obj = null;
            try {
                obj = this.task.execute();
            }
            catch (Throwable ex) {
                obj = ex;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskExecutor.this.waitBox.setVisible(false);
                }
            });
            EventQueue.invokeLater(new ResultRunnable(obj, this.task));
        }
    }
}

