/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.app.docs.listener;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import ru.softlogic.rma.app.CommissionCalculator;
import ru.softlogic.rma.connector.model.Commission;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.utils.SumFormatter;

public class SumOutcomeListener
implements DocumentListener {
    private JTextField sumIncomeField;
    private DocumentListener sumIncomeListener;
    private JTextField commissionField;
    private MenuItem menuItem;
    private Integer sumTrade;
    private Commission whiteCommission;
    private Runnable changeListener;

    public SumOutcomeListener(JTextField sumIncomeField, JTextField commissionField) {
        if (sumIncomeField == null) {
            throw new IllegalArgumentException("Need outcome summ field");
        }
        if (commissionField == null) {
            throw new IllegalArgumentException("Need commission field");
        }
        this.sumIncomeField = sumIncomeField;
        this.commissionField = commissionField;
    }

    public void setSumIncomeListener(DocumentListener sumIncomeListener) {
        this.sumIncomeListener = sumIncomeListener;
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
    }

    public void init(MenuItem menuItem, Integer sumTrade) {
        this.menuItem = menuItem;
        this.sumTrade = sumTrade;
    }

    public Commission getWhiteCommission() {
        return this.whiteCommission;
    }

    public void setWhiteCommission(Commission whiteCommission) {
        this.whiteCommission = whiteCommission;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.change(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.change(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.change(e);
    }

    private void change(DocumentEvent e) {
        if (this.sumIncomeListener == null) {
            throw new IllegalArgumentException("Need outcome listener");
        }
        if (this.menuItem == null) {
            throw new IllegalArgumentException("Need MenuItem for comission");
        }
        this.sumIncomeField.getDocument().removeDocumentListener(this.sumIncomeListener);
        try {
            String text = e.getDocument().getText(0, e.getDocument().getLength());
            int sumOutcome = SumFormatter.parce(text);
            int sumIncome = CommissionCalculator.calculateIncome(sumOutcome, this.menuItem.getCommission(), this.menuItem.getService().getCommission(), this.menuItem.getService().getMinCommission(), this.whiteCommission, this.sumTrade);
            this.sumIncomeField.setText(SumFormatter.format(sumIncome));
            this.commissionField.setText(SumFormatter.format(sumIncome - sumOutcome));
        }
        catch (NumberFormatException ex) {
            this.sumIncomeField.setText("");
            this.commissionField.setText("");
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.sumIncomeField.getDocument().addDocumentListener(this.sumIncomeListener);
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }
}

