/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.app.docs.listener;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import ru.softlogic.rma.app.CommissionCalculator;
import ru.softlogic.rma.connector.model.Commission;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.SumResult;
import ru.softlogic.rma.utils.SumFormatter;

public class SumIncomeListener
implements DocumentListener {
    private JTextField sumOutcomeField;
    private DocumentListener sumOutcomeListener;
    private JTextField commissionField;
    private MenuItem menuItem;
    private Integer sumTrade;
    private Commission whiteCommission;
    private Runnable changeListener;

    public SumIncomeListener(JTextField sumOutcomeField, JTextField commissionField) {
        if (sumOutcomeField == null) {
            throw new IllegalArgumentException("Need outcome summ field");
        }
        if (commissionField == null) {
            throw new IllegalArgumentException("Need commission field");
        }
        this.sumOutcomeField = sumOutcomeField;
        this.commissionField = commissionField;
    }

    public void setSumOutcomeListener(DocumentListener sumOutcomeListener) {
        this.sumOutcomeListener = sumOutcomeListener;
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
    }

    public void init(MenuItem menuItem, Integer sumTrade) {
        this.menuItem = menuItem;
        this.sumTrade = sumTrade;
    }

    public Commission getWhiteCommission() {
        return this.whiteCommission;
    }

    public void setWhiteCommission(Commission whiteCommission) {
        this.whiteCommission = whiteCommission;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.change(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.change(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.change(e);
    }

    private void change(DocumentEvent e) {
        if (this.sumOutcomeListener == null) {
            throw new IllegalArgumentException("Need outcome listener");
        }
        if (this.menuItem == null) {
            throw new IllegalArgumentException("Need MenuItem for comission");
        }
        this.sumOutcomeField.getDocument().removeDocumentListener(this.sumOutcomeListener);
        try {
            String text = e.getDocument().getText(0, e.getDocument().getLength());
            SumResult sumResult = CommissionCalculator.calculate(SumFormatter.parce(text), this.menuItem.getCommission(), this.menuItem.getService().getCommission(), this.menuItem.getService().getMinCommission(), this.whiteCommission, this.sumTrade);
            this.sumOutcomeField.setText(SumFormatter.format(sumResult.getOut()));
            this.commissionField.setText(SumFormatter.format(sumResult.getCommission()));
        }
        catch (NumberFormatException ex) {
            this.sumOutcomeField.setText("");
            this.commissionField.setText("");
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.sumOutcomeField.getDocument().addDocumentListener(this.sumOutcomeListener);
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }
}

