/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.app.docs;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumericDocument
extends PlainDocument {
    private int unitCount;
    private int decimalCount;
    private String regex;

    public NumericDocument(int unitCount, int decimalCount) {
        if (unitCount < 1) {
            throw new IllegalArgumentException("Wrong value unitCount");
        }
        if (unitCount < 0) {
            throw new IllegalArgumentException("Wrong value decimalCount");
        }
        this.unitCount = unitCount;
        this.decimalCount = decimalCount;
        this.regex = decimalCount > 0 ? "^\\d{1," + unitCount + "}((\\.|,)\\d{0," + decimalCount + "})?$" : "^\\d{1," + unitCount + "}$";
        System.out.println("regex=" + this.regex);
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        str = str.replace(',', '.');
        char[] addedFigures = str.toCharArray();
        StringBuilder data = new StringBuilder(this.getText(0, this.getLength()));
        data.insert(offs, new String(addedFigures));
        if (data.toString().matches(this.regex)) {
            super.insertString(offs, new String(addedFigures), a);
        } else {
            for (int i = addedFigures.length; i > 0; --i) {
                char c = addedFigures[i - 1];
                data = new StringBuilder(this.getText(0, this.getLength()));
                data.insert(offs, c);
                String newData = data.toString();
                if (!newData.matches("^\\d{1,5}((\\.|,)\\d{0,2})?$") || !Character.isDigit(c) && c != '.' && c != ',') continue;
                super.insertString(offs, new Character(c).toString(), a);
            }
        }
    }
}

