/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.app.config.utils;

import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import ru.softlogic.rma.app.config.model.Profile;
import ru.softlogic.rma.app.config.model.TerminalKey;
import ru.softlogic.rma.app.config.utils.KeyPair;
import ru.softlogic.rma.utils.PathUtils;
import ru.softlogic.system.util.FileUtil;

public class KeyLoader {
    public static String PRIVATE_KEY = "_private.key";
    public static String PUBLIC_KEY = "_public.key";

    public static TerminalKey loadKey(File file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0444\u0430\u0439\u043b");
        }
        if (!file.isFile() || !file.canRead()) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0444\u0430\u0439\u043b");
        }
        Logger log = Logger.getLogger((String)"app");
        log.setAdditivity(false);
        log.info((Object)("\u0412\u044b\u0431\u0440\u0430\u043d \u0444\u0430\u0439\u043b: " + file.getAbsolutePath()));
        Document document = null;
        try {
            Integer idPoint = null;
            String ip = null;
            String port = null;
            String httpPort = null;
            String privKey = null;
            String pubKey = null;
            log.info((Object)"\u0427\u0438\u0442\u0430\u044e \u0444\u0430\u0439\u043b \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443");
            SAXReader reader = new SAXReader();
            document = reader.read(file);
            Element root = document.getRootElement();
            if (!root.getName().equals("auth")) {
                throw new Exception("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 XML. \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 auth");
            }
            List elements = root.elements();
            for (Object obj : elements) {
                Element key;
                Element el = (Element)obj;
                if (el.getName().equals("point")) {
                    try {
                        idPoint = Integer.parseInt(el.valueOf("@id"));
                    }
                    catch (NumberFormatException ex) {
                        throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043d\u043e\u043c\u0435\u0440\u0430 \u0442\u043e\u0447\u043a\u0438", ex);
                    }
                    log.info((Object)("\u041d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0435\u043a\u0446\u0438\u044f \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438 \u0442\u043e\u0447\u043a\u0438: " + idPoint));
                    key = el.element("key");
                    if (key == null) continue;
                    privKey = key.getStringValue();
                    continue;
                }
                if (!el.getName().equals("server")) continue;
                ip = el.valueOf("@ip");
                port = el.valueOf("@port");
                httpPort = el.valueOf("@http_port");
                log.info((Object)("\u041d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0435\u043a\u0446\u0438\u044f \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + ip + ":" + port));
                key = el.element("key");
                if (key == null) continue;
                pubKey = key.getStringValue();
            }
            if (idPoint == null) {
                throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043d\u043e\u043c\u0435\u0440 \u0442\u043e\u0447\u043a\u0438");
            }
            if (ip == null || ip.length() == 0) {
                throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d ip \u0430\u0434\u0440\u0435\u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            }
            if (port == null || port.length() == 0) {
                throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0440\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            }
            if (privKey == null) {
                throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 \u0442\u043e\u0447\u043a\u0438");
            }
            if (pubKey == null) {
                throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            }
            return new TerminalKey(privKey, null, pubKey, ip, Integer.parseInt(httpPort), Integer.parseInt(port), idPoint);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    public static KeyPair loadKeyPairFromProfile(Profile profile) {
        String keyPath = PathUtils.getAppHome() + "/key/";
        String nameKey = profile.getId().replace("ws_", "");
        String privateKeyPath = keyPath + nameKey + PRIVATE_KEY;
        String publicKeyPath = keyPath + nameKey + PUBLIC_KEY;
        String privKey = null;
        String pubKey = null;
        try {
            privKey = FileUtil.loadFromFile(new File(privateKeyPath));
            pubKey = FileUtil.loadFromFile(new File(publicKeyPath));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new KeyPair(privKey, pubKey);
    }
}

