/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.app.components;

import java.text.ParseException;
import java.util.Map;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MaskFormatter;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.RegexFormatter;

public class MultipleMaskTextField
extends JTextField {
    private Document doc;
    private String curMask = "";
    private JFormattedTextField ftf;
    private String prefix;
    private String defMask;
    private Map<String, String> rules;

    public MultipleMaskTextField(Document doc, String prefix, Formatter formatter) {
        this.doc = doc;
        this.prefix = prefix;
        if (this.prefix == null) {
            this.prefix = "";
        }
        if (formatter instanceof RegexFormatter) {
            RegexFormatter rf = (RegexFormatter)formatter;
            this.defMask = rf.getDefaultMask() != null ? rf.getDefaultMask() : "";
            this.rules = rf.getMasks();
        } else {
            this.defMask = "";
        }
        if (this.defMask.length() == 0) {
            this.setDocument(doc);
        }
        this.getDocument().addDocumentListener(new MMFListener());
        this.setText(" ");
        this.setText("");
    }

    public MultipleMaskTextField(Document doc, String prefix, String defMask, Map<String, String> rules) {
        this.doc = doc;
        this.prefix = prefix;
        if (this.prefix == null) {
            this.prefix = "";
        }
        this.defMask = defMask;
        if (this.defMask == null) {
            this.defMask = "";
        }
        this.curMask = defMask;
        if (this.defMask.length() == 0) {
            this.setDocument(doc);
        }
        this.rules = rules;
        this.getDocument().addDocumentListener(new MMFListener());
        this.setText(" ");
        this.setText("");
    }

    @Override
    public void setText(String t) {
        try {
            this.doc.remove(0, this.doc.getLength());
            this.doc.insertString(0, t, null);
            super.setText(t);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public String getText() {
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException ex) {
            return "";
        }
    }

    public String getTextTitle() {
        return super.getText().trim();
    }

    private String getValueToInsert(String curMask, String text) {
        if (curMask == null) {
            return text;
        }
        int ind = curMask.indexOf(42);
        if (ind != -1) {
            return curMask.substring(0, ind) + text;
        }
        return text;
    }

    private class MMFListener
    implements DocumentListener {
        private boolean listenerActiv = true;

        private MMFListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (!this.listenerActiv) {
                return;
            }
            if (MultipleMaskTextField.this.defMask.length() == 0) {
                return;
            }
            int inPos = 0;
            if (e.getLength() != 0) {
                try {
                    inPos = this.getPosInDoc(e.getOffset()) - MultipleMaskTextField.this.prefix.length();
                    inPos = inPos > MultipleMaskTextField.this.doc.getText(0, MultipleMaskTextField.this.doc.getLength()).length() ? MultipleMaskTextField.this.doc.getText(0, MultipleMaskTextField.this.doc.getLength()).length() : inPos;
                    MultipleMaskTextField.this.doc.insertString(inPos, e.getDocument().getText(e.getOffset(), e.getLength()), null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            inPos += MultipleMaskTextField.this.prefix.length();
            this.switchMask();
            final DocumentEvent evt = e;
            int tmpCarPos = 0;
            try {
                tmpCarPos = this.getCarPosNewMask(inPos + e.getLength() - 1 >= MultipleMaskTextField.this.doc.getText(0, MultipleMaskTextField.this.doc.getLength()).length() ? MultipleMaskTextField.this.doc.getText(0, MultipleMaskTextField.this.doc.getLength()).length() - 1 : inPos + e.getLength() - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            final int carPos = tmpCarPos;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        MMFListener.this.listenerActiv = false;
                        evt.getDocument().remove(0, evt.getDocument().getLength());
                        String val = MultipleMaskTextField.this.getValueToInsert(MultipleMaskTextField.this.curMask, MultipleMaskTextField.this.doc.getText(0, MultipleMaskTextField.this.doc.getLength()));
                        MultipleMaskTextField.this.ftf.setText(val);
                        evt.getDocument().insertString(0, MultipleMaskTextField.this.ftf.getText(), null);
                        MMFListener.this.listenerActiv = true;
                        MultipleMaskTextField.this.setCaretPosition(carPos);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (!this.listenerActiv) {
                return;
            }
            if (MultipleMaskTextField.this.defMask.length() == 0) {
                return;
            }
            int off = e.getOffset();
            boolean remIndex = false;
            int from = this.getPosInDoc(e.getOffset()) - MultipleMaskTextField.this.prefix.length();
            int to = this.getPosInDoc(e.getOffset() + e.getLength()) - MultipleMaskTextField.this.prefix.length();
            if (e.getLength() == 1 && from == to) {
                --from;
            }
            if (from < 0) {
                from = 0;
            }
            if (to < 0) {
                to = 0;
            }
            try {
                MultipleMaskTextField.this.doc.remove(from, to - from);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.switchMask();
            final DocumentEvent evt = e;
            final int carPos = this.getCarPosNewMask((from += MultipleMaskTextField.this.prefix.length()) - 1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        MMFListener.this.listenerActiv = false;
                        evt.getDocument().remove(0, evt.getDocument().getLength());
                        String val = MultipleMaskTextField.this.getValueToInsert(MultipleMaskTextField.this.curMask, MultipleMaskTextField.this.doc.getText(0, MultipleMaskTextField.this.doc.getLength()));
                        MultipleMaskTextField.this.ftf.setText(val);
                        evt.getDocument().insertString(0, MultipleMaskTextField.this.ftf.getText(), null);
                        MMFListener.this.listenerActiv = true;
                        MultipleMaskTextField.this.setCaretPosition(carPos);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private int getCarPosNewMask(int remIndex) {
            int sum = -1;
            for (int i = 0; i < MultipleMaskTextField.this.curMask.length(); ++i) {
                if (sum == remIndex) {
                    for (int j = i; j < MultipleMaskTextField.this.curMask.length(); ++j) {
                        if (MultipleMaskTextField.this.curMask.charAt(j) != '*') continue;
                        return j;
                    }
                    return MultipleMaskTextField.this.curMask.length();
                }
                if (MultipleMaskTextField.this.curMask.charAt(i) != '*') continue;
                ++sum;
            }
            return MultipleMaskTextField.this.curMask.length();
        }

        private int getPosInDoc(int offset) {
            int sum = 0;
            for (int i = 0; i < offset && i < MultipleMaskTextField.this.curMask.length(); ++i) {
                if (MultipleMaskTextField.this.curMask.charAt(i) != '*') continue;
                ++sum;
            }
            return sum;
        }

        private void switchMask() {
            if (MultipleMaskTextField.this.rules != null) {
                for (String regex : MultipleMaskTextField.this.rules.keySet()) {
                    if (!MultipleMaskTextField.this.getText().matches(regex)) continue;
                    MultipleMaskTextField.this.curMask = (String)MultipleMaskTextField.this.rules.get(regex);
                    try {
                        MultipleMaskTextField.this.ftf = new JFormattedTextField(new MaskFormatter(this.toMaskFormatterMask(MultipleMaskTextField.this.curMask)));
                    }
                    catch (ParseException ex) {
                        break;
                    }
                    return;
                }
            }
            MultipleMaskTextField.this.curMask = MultipleMaskTextField.this.defMask;
            try {
                MultipleMaskTextField.this.ftf = new JFormattedTextField(new MaskFormatter(MultipleMaskTextField.this.curMask));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        private String toMaskFormatterMask(String mask) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mask.length(); ++i) {
                if (mask.charAt(i) == '#' || mask.charAt(i) == 'U' || mask.charAt(i) == 'L' || mask.charAt(i) == 'A' || mask.charAt(i) == '?' || mask.charAt(i) == 'H') {
                    sb.append('\'');
                    sb.append(mask.charAt(i));
                    continue;
                }
                sb.append(mask.charAt(i));
            }
            return sb.toString();
        }
    }
}

