/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.app.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class JScrollPopupMenu
extends JPopupMenu {
    private JList<String> list;
    private DefaultListModel listModel;
    private JTextField field;
    private JScrollPane scroller;
    private final int MAX_ROW_COUNT = 3;
    private Runnable popupListener;

    public JScrollPopupMenu(JTextField textField) {
        if (textField == null) {
            throw new NullPointerException();
        }
        this.field = textField;
        this.list = new JList(){

            @Override
            public void processMouseEvent(MouseEvent e) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers() ^ toolkit.getMenuShortcutKeyMask(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), 0);
                super.processMouseEvent(e);
            }
        };
        this.listModel = new DefaultListModel();
        this.list.setModel(this.listModel);
        this.list.addMouseListener(new Handler());
        this.list.setFont(this.field.getFont());
        this.list.setForeground(this.field.getForeground());
        this.list.setBackground(this.field.getBackground());
        this.list.setSelectionForeground(UIManager.getColor("ComboBox.selectionForeground"));
        this.list.setSelectionBackground(UIManager.getColor("ComboBox.selectionBackground"));
        this.list.setBorder(null);
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        this.scroller = new JScrollPane(this.list, 20, 31);
        this.scroller.setHorizontalScrollBar(null);
        this.scroller.setFocusable(false);
        this.scroller.getVerticalScrollBar().setFocusable(false);
        this.scroller.setBorder(null);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(new LineBorder(Color.BLACK, 1));
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
    }

    public void setPopupListener(Runnable popupListener) {
        this.popupListener = popupListener;
    }

    @Override
    public JMenuItem add(String s) {
        this.listModel.addElement(s);
        return null;
    }

    @Override
    public JMenuItem add(JMenuItem mi) {
        this.listModel.addElement(mi.getText());
        return mi;
    }

    public int getItemsCount() {
        return this.listModel.getSize();
    }

    public void clearItems() {
        this.listModel.clear();
    }

    @Override
    public void show() {
        Point location = this.getPopupLocation();
        this.show(this.field, location.x, location.y);
        if (!this.listModel.isEmpty()) {
            this.list.setSelectedIndex(0);
        }
    }

    public synchronized void nextSelection() {
        if (this.list.getSelectedIndex() < this.listModel.size() - 1) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() + 1);
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        }
    }

    public synchronized void prevSelection() {
        if (this.list.getSelectedIndex() > 0) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() - 1);
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        }
    }

    public void selectCurrent() {
        if (this.list.getModel().getSize() > 0) {
            this.field.setText(this.list.getSelectedValue());
            this.hide();
            Runnable l = this.popupListener;
            if (l != null) {
                l.run();
            }
        }
    }

    @Override
    public void hide() {
        this.field.repaint();
        this.setVisible(false);
    }

    private Point getPopupLocation() {
        Dimension popupSize = this.field.getSize();
        Insets insets = this.getInsets();
        popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(3));
        Rectangle popupBounds = this.computePopupBounds(0, this.field.getBounds().height, popupSize.width, popupSize.height);
        Dimension scrollSize = popupBounds.getSize();
        Point popupLocation = popupBounds.getLocation();
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
        this.list.revalidate();
        return popupLocation;
    }

    protected void updateListBoxSelectionForEvent(MouseEvent anEvent, boolean shouldScroll) {
        Point location = anEvent.getPoint();
        if (this.list == null) {
            return;
        }
        int index = this.list.locationToIndex(location);
        if (index == -1) {
            index = location.y < 0 ? 0 : this.listModel.getSize() - 1;
        }
        if (this.list.getSelectedIndex() != index) {
            this.list.setSelectedIndex(index);
            if (shouldScroll) {
                this.list.ensureIndexIsVisible(index);
            }
        }
    }

    protected int getPopupHeightForRowCount(int maxRowCount) {
        Insets insets;
        Border border;
        int minRowCount = Math.min(maxRowCount, this.listModel.getSize());
        int height = 0;
        ListCellRenderer<String> renderer = this.list.getCellRenderer();
        String value = null;
        for (int i = 0; i < minRowCount; ++i) {
            value = this.list.getModel().getElementAt(i);
            Component c = renderer.getListCellRendererComponent(this.list, value, i, false, false);
            height += c.getPreferredSize().height;
        }
        if (height == 0) {
            height = this.field.getHeight();
        }
        if ((border = this.scroller.getViewportBorder()) != null) {
            insets = border.getBorderInsets(null);
            height += insets.top + insets.bottom;
        }
        if ((border = this.scroller.getBorder()) != null) {
            insets = border.getBorderInsets(null);
            height += insets.top + insets.bottom;
        }
        return height;
    }

    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        Rectangle screenBounds;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = this.field.getGraphicsConfiguration();
        Point p = new Point();
        SwingUtilities.convertPointFromScreen(p, this.field);
        if (gc != null) {
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds = gc.getBounds();
            screenBounds.width -= screenInsets.left + screenInsets.right;
            screenBounds.height -= screenInsets.top + screenInsets.bottom;
            screenBounds.x += p.x + screenInsets.left;
            screenBounds.y += p.y + screenInsets.top;
        } else {
            screenBounds = new Rectangle(p, toolkit.getScreenSize());
        }
        Rectangle rect = new Rectangle(px, py, pw, ph);
        if (py + ph > screenBounds.y + screenBounds.height && ph < screenBounds.height) {
            rect.y = -rect.height;
        }
        return rect;
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }

    private class Handler
    implements ItemListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    Serializable {
        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == JScrollPopupMenu.this.list) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e) || !JScrollPopupMenu.this.field.isEnabled()) {
                return;
            }
            if (JScrollPopupMenu.this.field.isRequestFocusEnabled()) {
                JScrollPopupMenu.this.field.requestFocus();
            }
            JScrollPopupMenu.this.togglePopup();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == JScrollPopupMenu.this.list) {
                int index;
                if (JScrollPopupMenu.this.list.getModel().getSize() > 0 && (index = JScrollPopupMenu.this.list.locationToIndex(e.getPoint())) >= 0 && index < JScrollPopupMenu.this.list.getModel().getSize()) {
                    JScrollPopupMenu.this.field.setText((String)JScrollPopupMenu.this.list.getModel().getElementAt(index));
                    Runnable l = JScrollPopupMenu.this.popupListener;
                    if (l != null) {
                        l.run();
                    }
                }
                JScrollPopupMenu.this.setVisible(false);
                return;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent anEvent) {
            if (anEvent.getSource() == JScrollPopupMenu.this.list) {
                Point location = anEvent.getPoint();
                Rectangle r = new Rectangle();
                JScrollPopupMenu.this.list.computeVisibleRect(r);
                if (r.contains(location)) {
                    JScrollPopupMenu.this.updateListBoxSelectionForEvent(anEvent, false);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

