/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.app.components;

import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.app.components.CartPanel;
import ru.softlogic.rma.app.docs.DigitalNumberDocument;
import ru.softlogic.rma.model.CartPaymentTableModel;
import ru.softlogic.rma.model.CartTableMouseListener;
import ru.softlogic.rma.model.keeperpayments.IKeeperUpdateListener;
import ru.softlogic.rma.model.keeperpayments.KeeperPayment;
import ru.softlogic.rma.model.keeperpayments.PaymentData;
import ru.softlogic.rma.utils.SumFormatter;

public class CartPanel2
extends JPanel {
    private CartPaymentTableModel cartPaymentModel;
    private int paymentsSum;
    private CartTableMouseListener pml;
    private JPanel cartPanel;
    private JTable cartPaymentsTable;
    private JTextField comissionTextField;
    private JTextField countTextField;
    private JTextField incomeTextField;
    private JPanel jPanel1;
    private JButton okButton;
    private JTextField outcomeTextField;
    private JScrollPane paymentScrollPane;
    private JTextField sumChangeField;
    private JLabel sumChangeLabel;
    private JTextField sumIncomeField;
    private JLabel sumIncomeLabel;
    private JLabel totalCommissionLabel;
    private JLabel totalIncomeLabel;
    private JLabel totalPaymentsLabel;
    private JLabel totalSumLabel;
    private JButton canselButton;

    public CartPanel2(boolean contentPanel) {
        if (contentPanel) {
            this.initComponentsContentPanel();
        } else {
            this.initComponentsHorizontal();
        }
        this.sumIncomeField.setDocument(new DigitalNumberDocument(10, "", Character.valueOf('.')));
        this.sumIncomeField.getDocument().addDocumentListener(new LocalDocumentListener());
        this.pml = new CartTableMouseListener(this.cartPaymentsTable);
        this.cartPaymentModel = new CartPaymentTableModel();
        KeeperPayment.getInstanse().addUpdateListener(this.cartPaymentModel);
        this.canselButton.setEnabled(false);
        KeeperPayment.getInstanse().addUpdateListener(new IKeeperUpdateListener(){

            @Override
            public void updateState(PaymentData paymentData) {
                CartPanel2.this.canselButton.setEnabled(paymentData != null && paymentData.getToPayRecords() != null && !paymentData.getToPayRecords().isEmpty());
            }
        });
        this.cartPaymentsTable.setModel(this.cartPaymentModel);
        this.cartPaymentsTable.addMouseListener(this.pml);
        this.cartPaymentsTable.setAutoResizeMode(4);
        this.cartPaymentsTable.getColumnModel().getColumn(0).setPreferredWidth(120);
        this.cartPaymentsTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.cartPaymentsTable.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.cartPaymentsTable.getColumnModel().getColumn(3).setPreferredWidth(120);
        this.cartPaymentsTable.getColumnModel().getColumn(4).setPreferredWidth(60);
        this.cartPaymentsTable.getColumnModel().getColumn(5).setPreferredWidth(60);
        this.cartPaymentsTable.setSelectionMode(0);
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.pml.setPopupMenu(menu);
    }

    public void setRemoveMenuItem(JMenuItem removeItem) {
        this.pml.setRemoveMenuItem(removeItem);
    }

    public void setPrintMenuItem(JMenuItem reprintItem) {
        this.pml.setReprintMenuItem(reprintItem);
    }

    public void setPaymentsSum(int paymentsSum) {
        this.paymentsSum = paymentsSum;
        this.incomeTextField.setText(SumFormatter.format(paymentsSum));
        this.calcSum();
    }

    public JTextField getComissionTextField() {
        return this.comissionTextField;
    }

    public JTextField getCountTextField() {
        return this.countTextField;
    }

    public JTextField getOutcomeTextField() {
        return this.outcomeTextField;
    }

    public CartPaymentTableModel getCartPaymentModel() {
        return this.cartPaymentModel;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getCanselButton() {
        return this.canselButton;
    }

    public JTextField getSumIncomeField() {
        return this.sumIncomeField;
    }

    private void calcSum() {
        try {
            int koef = 100;
            long income = Math.round((double)koef * Double.parseDouble(this.sumIncomeField.getText().trim()));
            if (income > (long)this.paymentsSum) {
                this.sumChangeField.setText(SumFormatter.format(income - (long)this.paymentsSum));
            } else {
                this.sumChangeField.setText("0");
            }
        }
        catch (Exception e) {
            this.sumChangeField.setText("0");
        }
    }

    private void initComponentsHorizontal() {
        this.cartPanel = new JPanel();
        this.paymentScrollPane = new JScrollPane();
        this.cartPaymentsTable = new JTable();
        this.jPanel1 = new JPanel();
        this.totalPaymentsLabel = new JLabel();
        this.countTextField = new JTextField();
        this.totalSumLabel = new JLabel();
        this.outcomeTextField = new JTextField();
        this.totalCommissionLabel = new JLabel();
        this.comissionTextField = new JTextField();
        this.totalIncomeLabel = new JLabel();
        this.incomeTextField = new JTextField();
        this.sumIncomeLabel = new JLabel();
        this.sumIncomeField = new JTextField();
        this.sumChangeLabel = new JLabel();
        this.sumChangeField = new JTextField();
        this.okButton = new JButton();
        this.canselButton = new JButton();
        this.setName("Form");
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(CartPanel.class);
        this.cartPanel.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("RmaView.cart.title.text", new Object[0])));
        this.cartPanel.setName("cartPanel");
        this.paymentScrollPane.setName("paymentScrollPane");
        this.cartPaymentsTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.cartPaymentsTable.setAutoResizeMode(4);
        this.cartPaymentsTable.setName("cartPaymentsTable");
        this.cartPaymentsTable.getTableHeader().setReorderingAllowed(false);
        this.paymentScrollPane.setViewportView(this.cartPaymentsTable);
        this.jPanel1.setName("jPanel1");
        this.totalPaymentsLabel.setFont(resourceMap.getFont("RmaView.cart.Label.font"));
        this.totalPaymentsLabel.setText(resourceMap.getString("RmaView.cart.totalPaymentsLabel.text", new Object[0]));
        this.totalPaymentsLabel.setFocusable(false);
        this.totalPaymentsLabel.setName("totalPaymentsLabel");
        this.countTextField.setEditable(false);
        this.countTextField.setFont(resourceMap.getFont("RmaView.cart.TextField.font"));
        this.countTextField.setHorizontalAlignment(0);
        this.countTextField.setText(resourceMap.getString("countTextField.text", new Object[0]));
        this.countTextField.setFocusable(false);
        this.countTextField.setName("countTextField");
        this.totalSumLabel.setFont(resourceMap.getFont("RmaView.cart.Label.font"));
        this.totalSumLabel.setText(resourceMap.getString("RmaView.cart.totalSumLabel.text", new Object[0]));
        this.totalSumLabel.setFocusable(false);
        this.totalSumLabel.setName("totalSumLabel");
        this.totalSumLabel.setRequestFocusEnabled(false);
        this.outcomeTextField.setEditable(false);
        this.outcomeTextField.setFont(resourceMap.getFont("RmaView.cart.TextField.font"));
        this.outcomeTextField.setHorizontalAlignment(4);
        this.outcomeTextField.setFocusable(false);
        this.outcomeTextField.setName("outcomeTextField");
        this.totalCommissionLabel.setFont(resourceMap.getFont("RmaView.cart.Label.font"));
        this.totalCommissionLabel.setText(resourceMap.getString("RmaView.cart.totalCommissionLabel.text", new Object[0]));
        this.totalCommissionLabel.setFocusable(false);
        this.totalCommissionLabel.setName("totalCommissionLabel");
        this.comissionTextField.setEditable(false);
        this.comissionTextField.setFont(resourceMap.getFont("RmaView.cart.TextField.font"));
        this.comissionTextField.setHorizontalAlignment(4);
        this.comissionTextField.setFocusable(false);
        this.comissionTextField.setName("comissionTextField");
        this.totalIncomeLabel.setFont(resourceMap.getFont("RmaView.cart.Label.font"));
        this.totalIncomeLabel.setText(resourceMap.getString("RmaView.cart.totalIncomeLabel.text", new Object[0]));
        this.totalIncomeLabel.setFocusable(false);
        this.totalIncomeLabel.setName("totalIncomeLabel");
        this.incomeTextField.setEditable(false);
        this.incomeTextField.setFont(resourceMap.getFont("RmaView.cart.TextField.font"));
        this.incomeTextField.setHorizontalAlignment(4);
        this.incomeTextField.setFocusable(false);
        this.incomeTextField.setName("incomeTextField");
        this.sumIncomeLabel.setFont(resourceMap.getFont("RmaView.cart.Label.font"));
        this.sumIncomeLabel.setLabelFor(this.sumIncomeField);
        this.sumIncomeLabel.setText(resourceMap.getString("RmaView.cart.incomeLabel.text", new Object[0]));
        this.sumIncomeLabel.setFocusable(false);
        this.sumIncomeLabel.setName("sumIncomeLabel");
        this.sumIncomeField.setFont(resourceMap.getFont("RmaView.cart.TextField.font"));
        this.sumIncomeField.setText(resourceMap.getString("sumIncomeField.text", new Object[0]));
        this.sumIncomeField.setName("sumIncomeField");
        this.sumChangeLabel.setFont(resourceMap.getFont("RmaView.cart.Label.font"));
        this.sumChangeLabel.setText(resourceMap.getString("RmaView.cart.changeLabel.text", new Object[0]));
        this.sumChangeLabel.setFocusable(false);
        this.sumChangeLabel.setName("sumChangeLabel");
        this.sumChangeField.setEditable(false);
        this.sumChangeField.setFont(resourceMap.getFont("RmaView.cart.TextField.font"));
        this.sumChangeField.setHorizontalAlignment(4);
        this.sumChangeField.setText(resourceMap.getString("sumChangeField.text", new Object[0]));
        this.sumChangeField.setFocusable(false);
        this.sumChangeField.setName("sumChangeField");
        this.okButton.setText(resourceMap.getString("RmaView.cart.okButton.text", new Object[0]));
        this.okButton.setName("okButton");
        this.canselButton.setText(resourceMap.getString("RmaView.cart.canselButton.text", new Object[0]));
        this.canselButton.setName("canselButton");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.canselButton, -1, -1, Short.MAX_VALUE).addComponent(this.okButton, -1, -1, Short.MAX_VALUE).addComponent(this.sumChangeField, GroupLayout.Alignment.LEADING).addComponent(this.sumIncomeLabel, GroupLayout.Alignment.LEADING).addComponent(this.sumIncomeField, GroupLayout.Alignment.LEADING, -1, 200, Short.MAX_VALUE).addComponent(this.sumChangeLabel, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.countTextField, -2, 150, -2).addComponent(this.totalSumLabel).addComponent(this.outcomeTextField, -2, 150, -2).addComponent(this.totalPaymentsLabel).addComponent(this.totalIncomeLabel).addComponent(this.incomeTextField, -2, 150, -2).addComponent(this.totalCommissionLabel).addComponent(this.comissionTextField, -2, 150, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.totalPaymentsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countTextField, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.totalSumLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outcomeTextField, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.totalCommissionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comissionTextField, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.totalIncomeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.incomeTextField, -2, 30, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.sumIncomeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sumIncomeField, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sumChangeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sumChangeField, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGap(12, 12, 12).addComponent(this.okButton, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGap(12, 12, 12).addComponent(this.canselButton, -2, 45, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout cartPanelLayout = new GroupLayout(this.cartPanel);
        this.cartPanel.setLayout(cartPanelLayout);
        cartPanelLayout.setHorizontalGroup(cartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, cartPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.paymentScrollPane, -1, 450, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        cartPanelLayout.setVerticalGroup(cartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cartPanelLayout.createSequentialGroup().addGroup(cartPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.paymentScrollPane, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cartPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cartPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void initComponentsContentPanel() {
        this.cartPanel = new JPanel();
        this.paymentScrollPane = new JScrollPane();
        this.cartPaymentsTable = new JTable();
        this.sumIncomeLabel = new JLabel();
        this.sumIncomeField = new JTextField();
        this.sumChangeLabel = new JLabel();
        this.sumChangeField = new JTextField();
        this.okButton = new JButton();
        this.jPanel1 = new JPanel();
        this.totalPaymentsLabel = new JLabel();
        this.countTextField = new JTextField();
        this.totalSumLabel = new JLabel();
        this.outcomeTextField = new JTextField();
        this.totalCommissionLabel = new JLabel();
        this.comissionTextField = new JTextField();
        this.totalIncomeLabel = new JLabel();
        this.incomeTextField = new JTextField();
        this.canselButton = new JButton();
        this.setName("Form");
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(CartPanel.class);
        this.cartPanel.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("RmaView.cart.title.text", new Object[0])));
        this.cartPanel.setName("cartPanel");
        this.paymentScrollPane.setName("paymentScrollPane");
        this.cartPaymentsTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.cartPaymentsTable.setAutoResizeMode(4);
        this.cartPaymentsTable.setName("cartPaymentsTable");
        this.cartPaymentsTable.getTableHeader().setReorderingAllowed(false);
        this.paymentScrollPane.setViewportView(this.cartPaymentsTable);
        this.sumIncomeLabel.setFont(resourceMap.getFont("RmaView.cart.Label.font"));
        this.sumIncomeLabel.setLabelFor(this.sumIncomeField);
        this.sumIncomeLabel.setText(resourceMap.getString("RmaView.cart.incomeLabel.text", new Object[0]));
        this.sumIncomeLabel.setFocusable(false);
        this.sumIncomeLabel.setName("sumIncomeLabel");
        this.sumIncomeField.setFont(resourceMap.getFont("RmaView.cart.TextField.font"));
        this.sumIncomeField.setText(resourceMap.getString("sumIncomeField.text", new Object[0]));
        this.sumIncomeField.setName("sumIncomeField");
        this.sumChangeLabel.setFont(resourceMap.getFont("RmaView.cart.Label.font"));
        this.sumChangeLabel.setText(resourceMap.getString("RmaView.cart.changeLabel.text", new Object[0]));
        this.sumChangeLabel.setFocusable(false);
        this.sumChangeLabel.setName("sumChangeLabel");
        this.sumChangeField.setEditable(false);
        this.sumChangeField.setFont(resourceMap.getFont("RmaView.cart.TextField.font"));
        this.sumChangeField.setHorizontalAlignment(4);
        this.sumChangeField.setText(resourceMap.getString("sumChangeField.text", new Object[0]));
        this.sumChangeField.setFocusable(false);
        this.sumChangeField.setName("sumChangeField");
        this.okButton.setText(resourceMap.getString("RmaView.cart.okButton.text", new Object[0]));
        this.okButton.setName("okButton");
        this.jPanel1.setName("jPanel1");
        this.totalPaymentsLabel.setFont(resourceMap.getFont("RmaView.cart.Label.font"));
        this.totalPaymentsLabel.setText(resourceMap.getString("RmaView.cart.totalPaymentsLabel.text", new Object[0]));
        this.totalPaymentsLabel.setFocusable(false);
        this.totalPaymentsLabel.setName("totalPaymentsLabel");
        this.countTextField.setEditable(false);
        this.countTextField.setFont(resourceMap.getFont("RmaView.cart.TextField.font"));
        this.countTextField.setHorizontalAlignment(0);
        this.countTextField.setText(resourceMap.getString("countTextField.text", new Object[0]));
        this.countTextField.setFocusable(false);
        this.countTextField.setName("countTextField");
        this.totalSumLabel.setFont(resourceMap.getFont("RmaView.cart.Label.font"));
        this.totalSumLabel.setText(resourceMap.getString("RmaView.cart.totalSumLabel.text", new Object[0]));
        this.totalSumLabel.setFocusable(false);
        this.totalSumLabel.setName("totalSumLabel");
        this.totalSumLabel.setRequestFocusEnabled(false);
        this.outcomeTextField.setEditable(false);
        this.outcomeTextField.setFont(resourceMap.getFont("RmaView.cart.TextField.font"));
        this.outcomeTextField.setHorizontalAlignment(4);
        this.outcomeTextField.setFocusable(false);
        this.outcomeTextField.setName("outcomeTextField");
        this.totalCommissionLabel.setFont(resourceMap.getFont("RmaView.cart.Label.font"));
        this.totalCommissionLabel.setText(resourceMap.getString("RmaView.cart.totalCommissionLabel.text", new Object[0]));
        this.totalCommissionLabel.setFocusable(false);
        this.totalCommissionLabel.setName("totalCommissionLabel");
        this.comissionTextField.setEditable(false);
        this.comissionTextField.setFont(resourceMap.getFont("RmaView.cart.TextField.font"));
        this.comissionTextField.setHorizontalAlignment(4);
        this.comissionTextField.setFocusable(false);
        this.comissionTextField.setName("comissionTextField");
        this.totalIncomeLabel.setFont(resourceMap.getFont("RmaView.cart.Label.font"));
        this.totalIncomeLabel.setText(resourceMap.getString("RmaView.cart.totalIncomeLabel.text", new Object[0]));
        this.totalIncomeLabel.setFocusable(false);
        this.totalIncomeLabel.setName("totalIncomeLabel");
        this.incomeTextField.setEditable(false);
        this.incomeTextField.setFont(resourceMap.getFont("RmaView.cart.TextField.font"));
        this.incomeTextField.setHorizontalAlignment(4);
        this.incomeTextField.setFocusable(false);
        this.incomeTextField.setName("incomeTextField");
        this.canselButton.setText(resourceMap.getString("RmaView.cart.canselButton.text", new Object[0]));
        this.canselButton.setName("canselButton");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.countTextField, -2, 150, -2).addComponent(this.totalSumLabel).addComponent(this.outcomeTextField, -2, 150, -2).addComponent(this.totalCommissionLabel).addComponent(this.comissionTextField, -2, 150, -2).addComponent(this.totalIncomeLabel).addComponent(this.incomeTextField, -2, 150, -2).addComponent(this.totalPaymentsLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.totalPaymentsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countTextField, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.totalSumLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outcomeTextField, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.totalCommissionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comissionTextField, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.totalIncomeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.incomeTextField, -2, 30, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout cartPanelLayout = new GroupLayout(this.cartPanel);
        this.cartPanel.setLayout(cartPanelLayout);
        cartPanelLayout.setHorizontalGroup(cartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cartPanelLayout.createSequentialGroup().addContainerGap().addGroup(cartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.paymentScrollPane, -1, 830, Short.MAX_VALUE).addGroup(cartPanelLayout.createSequentialGroup().addGroup(cartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.canselButton, -1, -1, Short.MAX_VALUE).addComponent(this.okButton, -1, -1, Short.MAX_VALUE).addComponent(this.sumChangeField).addComponent(this.sumIncomeLabel).addComponent(this.sumIncomeField, -1, 200, Short.MAX_VALUE).addComponent(this.sumChangeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2))).addContainerGap()));
        cartPanelLayout.setVerticalGroup(cartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cartPanelLayout.createSequentialGroup().addGroup(cartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cartPanelLayout.createSequentialGroup().addComponent(this.sumIncomeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sumIncomeField, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sumChangeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sumChangeField, -2, 30, -2).addGap(12, 12, 12).addComponent(this.okButton, -2, 45, -2).addGap(12, 12, 12).addComponent(this.canselButton, -2, 45, -2)).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.paymentScrollPane, -1, 296, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cartPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cartPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void initComponents() {
        this.setName("Form");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private class LocalDocumentListener
    implements DocumentListener {
        private LocalDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CartPanel2.this.calcSum();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            CartPanel2.this.calcSum();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CartPanel2.this.calcSum();
        }
    }
}

