/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.app.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import rmai18n.LocBundle;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.app.helpers.reports.ReportListener;
import ru.softlogic.rma.connector.model.CurrentUser;
import ru.softlogic.rma.connector.model.ShiftInfo;
import ru.softlogic.rma.model.BalanceTableModel;
import ru.softlogic.rma.persistence.BalanceRecord;
import ru.softlogic.rma.persistence.PersistenceException;
import ru.softlogic.rma.persistence.v2.PersistenceManager;

public class BalanceDialog
extends JDialog {
    ShiftInfo shInfo;
    private BalanceTableModel btm;
    private Logger log;
    private SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:00");
    private SimpleDateFormat odayF = new SimpleDateFormat("yyyy-MM-dd");
    private ReportListener reportListener = null;
    private JButton closeButton;
    private JLabel closeTimeLable;
    private JLabel countpaymentsLable;
    private JButton exportButton;
    private JButton exportOperButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JLabel kassirCloseLable;
    private JLabel kassirOpenLable;
    private JPanel menuPanel;
    private JLabel openTimeLabel;
    private JLabel operatingDayLabel;
    private JLabel shiftNumberLabel;
    private JSplitPane splitPane;
    private JScrollPane statisticScrollPane;
    private JTable statisticTable;
    private JPanel titledPanel;

    public BalanceDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.log = Logger.getLogger((String)"app");
        this.log.setAdditivity(false);
        this.btm = new BalanceTableModel();
        this.statisticTable.setModel(this.btm);
        this.statisticTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.statisticTable.getColumnModel().getColumn(1).setPreferredWidth(180);
        this.statisticTable.getColumnModel().getColumn(2).setPreferredWidth(140);
        this.statisticTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.statisticTable.getColumnModel().getColumn(4).setPreferredWidth(110);
        this.statisticTable.getColumnModel().getColumn(5).setPreferredWidth(110);
        this.statisticTable.getColumnModel().getColumn(6).setPreferredWidth(100);
        this.statisticTable.getColumnModel().getColumn(7).setPreferredWidth(100);
        this.statisticTable.setDefaultRenderer(String.class, new LocalTableCellRenderer());
    }

    public void setShiftInfo(ShiftInfo info) {
        this.shInfo = info;
    }

    public void setReportListener(ReportListener reportListener) {
        this.reportListener = reportListener;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            if (this.shInfo == null) {
                this.shiftNumberLabel.setText("-");
                this.operatingDayLabel.setText("-");
                this.openTimeLabel.setText("-");
                this.closeTimeLable.setText("-");
                this.kassirOpenLable.setText("-");
                this.kassirCloseLable.setText("-");
                this.countpaymentsLable.setText("-");
            } else {
                this.shiftNumberLabel.setText(String.valueOf(this.shInfo.getNum()));
                this.operatingDayLabel.setText(this.shInfo.getOperDay());
                this.openTimeLabel.setText(this.sdf.format(this.shInfo.getStartTime()));
                this.closeTimeLable.setText(this.shInfo.getState() == 1 ? this.sdf.format(this.shInfo.getCloseTime()) : "-");
                this.kassirOpenLable.setText(this.shInfo.getOpenKassirName());
                this.kassirCloseLable.setText(this.shInfo.getCloseKassirName() != null ? this.shInfo.getCloseKassirName() : "-");
                this.countpaymentsLable.setText(String.valueOf(this.shInfo.getCoutPayments()));
            }
            this.calculateInfo();
        }
        super.setVisible(visible);
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.menuPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.shiftNumberLabel = new JLabel();
        this.operatingDayLabel = new JLabel();
        this.openTimeLabel = new JLabel();
        this.closeTimeLable = new JLabel();
        this.kassirOpenLable = new JLabel();
        this.kassirCloseLable = new JLabel();
        this.countpaymentsLable = new JLabel();
        this.titledPanel = new JPanel();
        this.statisticScrollPane = new JScrollPane();
        this.statisticTable = new JTable();
        this.jPanel1 = new JPanel();
        this.exportButton = new JButton();
        this.closeButton = new JButton();
        this.exportOperButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(BalanceDialog.class);
        this.setTitle(resourceMap.getString("BalanceDialog.title", new Object[0]));
        this.setModal(true);
        this.setName("Form");
        this.splitPane.setMinimumSize(new Dimension(1000, 2));
        this.splitPane.setName("splitPane");
        this.menuPanel.setMinimumSize(new Dimension(300, 0));
        this.menuPanel.setName("menuPanel");
        this.menuPanel.setPreferredSize(new Dimension(300, 0));
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.shiftNumberLabel.setText(resourceMap.getString("shiftNumberLabel.text", new Object[0]));
        this.shiftNumberLabel.setName("shiftNumberLabel");
        this.operatingDayLabel.setText(resourceMap.getString("operatingDayLabel.text", new Object[0]));
        this.operatingDayLabel.setName("operatingDayLabel");
        this.openTimeLabel.setText(resourceMap.getString("openTimeLabel.text", new Object[0]));
        this.openTimeLabel.setName("openTimeLabel");
        this.closeTimeLable.setText(resourceMap.getString("closeTimeLable.text", new Object[0]));
        this.closeTimeLable.setName("closeTimeLable");
        this.kassirOpenLable.setText(resourceMap.getString("kassirOpenLable.text", new Object[0]));
        this.kassirOpenLable.setName("kassirOpenLable");
        this.kassirCloseLable.setText(resourceMap.getString("kassirCloseLable.text", new Object[0]));
        this.kassirCloseLable.setName("kassirCloseLable");
        this.countpaymentsLable.setText(resourceMap.getString("countpaymentsLable.text", new Object[0]));
        this.countpaymentsLable.setName("countpaymentsLable");
        GroupLayout menuPanelLayout = new GroupLayout(this.menuPanel);
        this.menuPanel.setLayout(menuPanelLayout);
        menuPanelLayout.setHorizontalGroup(menuPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(menuPanelLayout.createSequentialGroup().addContainerGap().addGroup(menuPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(menuPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.shiftNumberLabel)).addGroup(menuPanelLayout.createSequentialGroup().addGroup(menuPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.jLabel1).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(menuPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.operatingDayLabel).addComponent(this.countpaymentsLable).addComponent(this.openTimeLabel).addComponent(this.closeTimeLable).addComponent(this.kassirCloseLable).addComponent(this.kassirOpenLable)))).addContainerGap(19, Short.MAX_VALUE)));
        menuPanelLayout.setVerticalGroup(menuPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(menuPanelLayout.createSequentialGroup().addGap(22, 22, 22).addGroup(menuPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.shiftNumberLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(menuPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.operatingDayLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(menuPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.openTimeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(menuPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.closeTimeLable)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(menuPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.kassirOpenLable)).addGap(12, 12, 12).addGroup(menuPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.kassirCloseLable)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(menuPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.countpaymentsLable)).addContainerGap(228, Short.MAX_VALUE)));
        this.splitPane.setLeftComponent(this.menuPanel);
        this.titledPanel.setName("titledPanel");
        this.titledPanel.setLayout(new BorderLayout());
        this.statisticScrollPane.setName("statisticScrollPane");
        this.statisticTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.statisticTable.setAutoResizeMode(1);
        this.statisticTable.setName("statisticTable");
        this.statisticScrollPane.setViewportView(this.statisticTable);
        this.titledPanel.add((Component)this.statisticScrollPane, "Center");
        this.splitPane.setRightComponent(this.titledPanel);
        this.jPanel1.setName("jPanel1");
        ApplicationActionMap actionMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getActionMap(BalanceDialog.class, (Object)this);
        this.exportButton.setAction(actionMap.get("export"));
        this.exportButton.setText(resourceMap.getString("BalanceDialog.exportButton.text", new Object[0]));
        this.exportButton.setToolTipText(resourceMap.getString("BalanceDialog.exportButton.toolTipText", new Object[0]));
        this.exportButton.setName("exportButton");
        this.exportButton.setPreferredSize(new Dimension(0, 22));
        this.closeButton.setAction(actionMap.get("close"));
        this.closeButton.setText(resourceMap.getString("BalanceDialog.closeButton.text", new Object[0]));
        this.closeButton.setToolTipText(resourceMap.getString("closeButton.toolTipText", new Object[0]));
        this.closeButton.setName("closeButton");
        this.closeButton.setPreferredSize(new Dimension(0, 22));
        this.exportOperButton.setAction(actionMap.get("exportOpreatings"));
        this.exportOperButton.setText(resourceMap.getString("exportOperButton.text", new Object[0]));
        this.exportOperButton.setName("exportOperButton");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(545, Short.MAX_VALUE).addComponent(this.exportOperButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportButton, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton, -2, 98, -2).addGap(26, 26, 26)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton, -2, -1, -2).addComponent(this.exportOperButton).addComponent(this.exportButton, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.splitPane, GroupLayout.Alignment.LEADING, -1, 1099, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.splitPane, -1, 429, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void calculateInfo() {
        try {
            List<BalanceRecord> records = PersistenceManager.getInstance().selectBalanceInfoForShift(this.shInfo.getIdShiftServer(), CurrentUser.getInstance().getUserId());
            if (!records.isEmpty()) {
                BalanceRecord total = new BalanceRecord();
                for (BalanceRecord item : records) {
                    total.setCountAll(total.getCountAll() + item.getCountAll());
                    total.setSumIncome(total.getSumIncome() + item.getSumIncome());
                    total.setCountCancelled(total.getCountCancelled() + item.getCountCancelled());
                    total.setSumCancelled(total.getSumCancelled() + item.getSumCancelled());
                    total.setSumComm(total.getSumComm() + item.getSumComm());
                    total.setCountError(total.getCountError() + item.getCountError());
                    total.setCountSuccess(total.getCountSuccess() + item.getCountSuccess());
                    total.setSumError(total.getSumError() + item.getSumError());
                }
                total.setServiceName(LocBundle.getMessage((String)"BalanceDialog.total.text"));
                records.add(total);
            }
            this.btm.setRecords(records.toArray(new BalanceRecord[records.size()]));
        }
        catch (PersistenceException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            JOptionPane.showMessageDialog(this, LocBundle.getMessage((String)"rma.view.bderror"), LocBundle.getMessage((String)"error"), 0);
            this.btm.setRecords(new BalanceRecord[0]);
        }
    }

    public ShiftInfo getShiftInfo() {
        return this.shInfo;
    }

    @Action
    public void close() {
        this.setVisible(false);
    }

    @Action
    public void export() {
        if (this.reportListener != null) {
            this.shInfo.setIsOperstings(false);
            this.reportListener.generateReport(this.shInfo);
        }
    }

    @Action
    public void exportOpreatings() {
        if (this.reportListener != null) {
            this.shInfo.setIsOperstings(true);
            this.reportListener.generateReport(this.shInfo);
        }
    }

    private class LocalTableCellRenderer
    extends DefaultTableCellRenderer {
        private LocalTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JLabel) {
                JLabel label = (JLabel)comp;
                if (column > 1) {
                    label.setHorizontalAlignment(4);
                    comp.setBackground(Color.WHITE);
                } else if (column == 0) {
                    label.setHorizontalAlignment(0);
                    comp.setBackground(Color.WHITE);
                } else {
                    label.setHorizontalAlignment(2);
                    comp.setBackground(Color.WHITE);
                }
                if (row == table.getRowCount() - 1) {
                    label.setText("<html><b>" + label.getText());
                    label.setBackground(new Color(209, 209, 209));
                }
            }
            return comp;
        }
    }
}

