/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.rma.app.ConfigurationData;
import ru.softlogic.rma.utils.PathUtils;

public class Configuration {
    private static Configuration instance = new Configuration();
    private ConfigurationData data;

    private Configuration() {
        try {
            this.readConfiguration();
        }
        catch (IOException ex) {
            Logger.getLogger((String)"app").error((Object)(LocBundle.getMessageLog((String)"rma.app.confreaderr") + ex.getMessage()));
        }
    }

    public static Configuration getInstance() {
        return instance;
    }

    public ConfigurationData getData() {
        return this.data;
    }

    public void writeConfiguration() throws IOException {
        String path = PathUtils.getDataPath();
        new File(path).mkdir();
        path = path + File.separator + "configuration";
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(path));){
            oos.writeObject(this.data);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public void readConfiguration() throws IOException {
        String path = PathUtils.getDataPath() + File.separator + "configuration";
        this.data = null;
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path));){
            Object loadedObj = ois.readObject();
            this.data = (ConfigurationData)loadedObj;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        finally {
            if (this.data == null) {
                this.data = new ConfigurationData();
            }
        }
    }
}

