/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.app;

import ru.softlogic.rma.connector.model.Commission;
import ru.softlogic.rma.connector.model.CommissionStep;
import ru.softlogic.rma.connector.model.SumResult;

public class CommissionCalculator {
    public static SumResult calculate(int in, Commission commission, Commission serviceCommission, Commission minCommission, Commission whiteCommission, Integer trade) {
        SumResult serviceResult;
        SumResult dealerResult;
        SumResult sumResult = dealerResult = whiteCommission == null ? CommissionCalculator.calculate(in, commission, trade) : CommissionCalculator.calculate(in, whiteCommission, trade);
        if (serviceCommission != null && (serviceResult = CommissionCalculator.calculate(in, serviceCommission, trade)).getCommission() < dealerResult.getCommission()) {
            dealerResult = serviceResult;
        }
        if (minCommission != null && (serviceResult = CommissionCalculator.calculate(in, minCommission, trade)).getCommission() > dealerResult.getCommission()) {
            dealerResult = serviceResult;
        }
        return dealerResult;
    }

    private static SumResult calculate(int in, Commission commission, Integer trade) {
        int rest;
        if (in < 0) {
            throw new IllegalArgumentException("Payment summ can not be < 0");
        }
        if (commission == null) {
            throw new IllegalArgumentException("Commission rate can not be");
        }
        int baseSum = 0;
        baseSum = trade != null && trade != 0 ? trade : in;
        int sumCommission = 0;
        int sumOut = 0;
        double percentValue = commission.getPercentValue();
        int fixedValue = commission.getFixedValue();
        CommissionStep cs = null;
        if (commission.getSteps() != null && commission.getSteps().size() > 0) {
            for (CommissionStep step : commission.getSteps().descendingSet()) {
                if (step.getSum() > baseSum) continue;
                cs = step;
                percentValue = step.getPercentValue();
                fixedValue = step.getFixedValue();
                break;
            }
        }
        switch (commission.getType()) {
            case Direct: {
                sumCommission = Math.round((float)((double)baseSum * percentValue / 100.0));
                break;
            }
            case Inverce: {
                sumCommission = Math.round((float)((double)baseSum * percentValue / (100.0 + percentValue)));
            }
        }
        if (cs != null && cs.getMin() != 0 && (sumCommission += fixedValue) < cs.getMin()) {
            sumCommission = cs.getMin();
        } else if (commission.getMin() != null && commission.getMin() != 0 && sumCommission < commission.getMin()) {
            sumCommission = commission.getMin();
        }
        if (cs != null && cs.getMax() != 0 && sumCommission > cs.getMax()) {
            sumCommission = cs.getMax();
        } else if (commission.getMax() != null && commission.getMax() != 0 && sumCommission > commission.getMax()) {
            sumCommission = commission.getMax();
        }
        if (commission.getRoundOrder() != null && commission.getRoundOrder() != 0 && (rest = sumCommission % commission.getRoundOrder()) != 0) {
            sumCommission = sumCommission + commission.getRoundOrder() - rest;
        }
        if (sumCommission > in) {
            return new SumResult(0, 0, in);
        }
        sumOut = in - sumCommission;
        if (trade != null && trade != 0) {
            if (sumOut < trade) {
                return new SumResult(0, 0, in);
            }
            return new SumResult(trade, sumCommission, sumOut - trade);
        }
        return new SumResult(sumOut, sumCommission, 0);
    }

    public static int calculateIncome(int out, Commission commission, Commission serviceCommission, Commission minCommission, Commission whiteCommission, Integer trade) {
        int serviceResult;
        int dealerResult;
        int n = dealerResult = whiteCommission == null ? CommissionCalculator.calculateIncome(out, commission, trade) : CommissionCalculator.calculateIncome(out, whiteCommission, trade);
        if (serviceCommission != null && (serviceResult = CommissionCalculator.calculateIncome(out, serviceCommission, trade)) < dealerResult) {
            dealerResult = serviceResult;
        }
        if (minCommission != null && (serviceResult = CommissionCalculator.calculateIncome(out, minCommission, trade)) > dealerResult) {
            dealerResult = serviceResult;
        }
        return dealerResult;
    }

    private static int calculateIncome(int out, Commission commission, Integer trade) {
        int in = out;
        int step = 1;
        SumResult res = CommissionCalculator.calculate(in, commission, trade);
        while (res.getOut() < out) {
            res = CommissionCalculator.calculate(in += step, commission, trade);
        }
        return in;
    }

    public static int calculateFee(int out, Commission commission) {
        if (out < 0) {
            throw new IllegalArgumentException("Payment summ can not be < 0");
        }
        if (commission != null) {
            int baseSum = out;
            int sumCommission = 0;
            double percentValue = commission.getPercentValue();
            sumCommission = Math.round((float)((double)baseSum * percentValue / 100.0 * 100.0));
            return sumCommission;
        }
        return 0;
    }
}

