/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.rma.connector.ConnectorException;
import ru.softlogic.rma.connector.ReferencesListener;
import ru.softlogic.rma.connector.model.NoResult;
import ru.softlogic.rma.connector.model.Point;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.connector.model.Response;
import ru.softlogic.rma.connector.model.command.Auth;
import ru.softlogic.rma.connector.model.command.Command;
import ru.softlogic.rma.connector.model.command.CommandResult;
import ru.softlogic.rma.connector.model.command.CommandResultType;
import ru.softlogic.rma.connector.ws.WSConnector;
import ru.softlogic.rma.mail.Mailer;
import ru.softlogic.rma.mail.MailerFactory;
import ru.softlogic.rma.utils.ThreadUtil;

public class CommandQueue
implements Runnable,
ReferencesListener {
    private ConcurrentLinkedQueue<Command> queue;
    private Auth auth;
    private WSConnector connector;
    private Logger logger;
    private List<CommandResult> results;
    private Date lastUpdate;
    private Point point;

    public CommandQueue(WSConnector connector) {
        this.connector = connector;
        this.queue = new ConcurrentLinkedQueue();
        this.logger = Logger.getLogger((String)"app");
        this.logger.setAdditivity(false);
        this.results = new LinkedList<CommandResult>();
        this.lastUpdate = new Date();
    }

    public void addCommand(Command command) {
        this.queue.add(command);
    }

    @Override
    public void run() {
        this.logger.info((Object)"Start Thread");
        ThreadUtil.sleep(60000L);
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Command cmd = this.queue.poll();
                if (cmd != null) {
                    if (cmd.getType() == null || cmd.getExecuteTill() == null) {
                        this.logger.error((Object)LocBundle.getMessageLog((String)"rma.command.error"));
                        this.results.add(new CommandResult(cmd.getId(), CommandResultType.BadParams, null));
                    } else if (cmd.getExecuteTill().compareTo(new Date()) < 0) {
                        this.logger.info((Object)LocBundle.getMessageLog((String)"rma.command.error"));
                        this.results.add(new CommandResult(cmd.getId(), CommandResultType.Timeout, null));
                    } else {
                        switch (cmd.getType()) {
                            case SendLog: {
                                this.sendLogs(cmd, false);
                                break;
                            }
                            case SendAllLog: {
                                this.sendLogs(cmd, true);
                                break;
                            }
                            default: {
                                this.logger.info((Object)LocBundle.getMessageLog((String)MessageFormat.format(LocBundle.getMessageLog((String)"rma.command.norelease"), cmd)));
                                this.results.add(new CommandResult(cmd.getId(), CommandResultType.Error, LocBundle.getMessageLog((String)"rma.command.norelease2")));
                            }
                        }
                    }
                }
                this.updateResults();
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.logger.info((Object)"Stop Thread");
    }

    @Override
    public void onReferences(References references) {
        if (references != null) {
            if (references.getAuth() != null) {
                this.auth = references.getAuth();
            }
            if (references.getPoint() != null) {
                this.point = references.getPoint();
            }
            if (references.getCommands() != null) {
                for (Command command : references.getCommands()) {
                    this.addCommand(command);
                }
            }
        }
    }

    private void sendLogs(Command cmd, boolean full) {
        String dateFrom = cmd.getParam1();
        String email = cmd.getParam2();
        String dateTo = cmd.getParam3();
        if (dateTo == null) {
            dateTo = dateFrom;
        }
        if (dateFrom == null || dateFrom.isEmpty() || email == null || email.isEmpty() || dateTo == null || dateTo.isEmpty()) {
            this.logger.error((Object)LocBundle.getMessageLog((String)"rma.command.error"));
            this.results.add(new CommandResult(cmd.getId(), CommandResultType.BadParams, null));
            return;
        }
        this.logger.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.command.needlogs"), dateFrom, dateTo, email));
        if (this.auth == null) {
            this.logger.info((Object)LocBundle.getMessageLog((String)"rma.command.noauth"));
            this.results.add(new CommandResult(cmd.getId(), CommandResultType.BadParams, LocBundle.getMessageLog((String)"rma.command.noauth")));
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date d1 = null;
        Date d2 = null;
        try {
            d1 = sdf.parse(dateFrom);
            d2 = sdf.parse(dateTo);
            this.logger.info((Object)(LocBundle.getMessageLog((String)"rma.command.repdate") + ": [" + d1 + "," + d2 + "]"));
        }
        catch (ParseException ex) {
            this.logger.info((Object)LocBundle.getMessageLog((String)"rma.command.repdateerr"), (Throwable)ex);
            this.results.add(new CommandResult(cmd.getId(), CommandResultType.BadParams, LocBundle.getMessageLog((String)"rma.command.repdateerr")));
            return;
        }
        if (d1.after(d2)) {
            Date d = d1;
            d1 = d2;
            d2 = d;
        }
        this.logger.info((Object)LocBundle.getMessageLog((String)"rma.command.formarch"));
        String rmaLogHome = System.getProperty("user.home") + File.separator + ".paylogic" + File.separator + "rma" + File.separator + "log" + File.separator;
        String rmaAddLogHome = System.getProperty("user.home") + File.separator + ".paylogic" + File.separator + "rma" + File.separator + "log" + File.separator + "add" + File.separator;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d1);
        LinkedList<String> paths = new LinkedList<String>();
        while (cal.getTime().compareTo(d2) <= 0) {
            Date dl = cal.getTime();
            String dls = sdf.format(dl);
            this.logger.info((Object)(LocBundle.getMessageLog((String)"rma.command.addlogs") + " " + dls));
            String postfix = "." + dls;
            if (sdf.format(new Date()).equals(dls)) {
                postfix = "";
            }
            if (new File(rmaLogHome + "pay.log" + postfix).exists()) {
                paths.add(rmaLogHome + "pay.log" + postfix);
            }
            if (new File(rmaLogHome + "uni.log" + postfix).exists()) {
                paths.add(rmaLogHome + "uni.log" + postfix);
            }
            if (full) {
                if (new File(rmaAddLogHome + "app.log" + postfix).exists()) {
                    paths.add(rmaAddLogHome + "app.log" + postfix);
                }
                if (new File(rmaAddLogHome + "network.log" + postfix).exists()) {
                    paths.add(rmaAddLogHome + "network.log" + postfix);
                }
                if (new File(rmaAddLogHome + "network-xml.log" + postfix).exists()) {
                    paths.add(rmaAddLogHome + "network-xml.log" + postfix);
                }
                if (new File(rmaAddLogHome + "persistence.log" + postfix).exists()) {
                    paths.add(rmaAddLogHome + "persistence.log" + postfix);
                }
                if (new File(rmaAddLogHome + "print.log" + postfix).exists()) {
                    paths.add(rmaAddLogHome + "print.log" + postfix);
                }
                if (new File(rmaAddLogHome + "scanner.log" + postfix).exists()) {
                    paths.add(rmaAddLogHome + "scanner.log" + postfix);
                }
                if (new File(rmaAddLogHome + "update.log" + postfix).exists()) {
                    paths.add(rmaAddLogHome + "update.log" + postfix);
                }
            }
            ((Calendar)cal).add(5, 1);
        }
        Mailer mailer = MailerFactory.gmail(this.auth, email);
        mailer.setSubject(MessageFormat.format(LocBundle.getMessageLog((String)"rma.command.messsub"), d1, d2));
        mailer.setLogFileName("logs_" + (this.point == null ? "0" : Short.valueOf(this.point.getId())));
        mailer.setTextMessage("");
        byte[] buf = new byte[2048];
        try {
            File tmpFile = File.createTempFile("zip", "tmp");
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tmpFile));
            zos.setLevel(9);
            for (int i = 0; i < paths.size(); ++i) {
                int len;
                File file = new File((String)paths.get(i));
                FileInputStream in = new FileInputStream(file);
                zos.putNextEntry(new ZipEntry(file.getName()));
                while ((len = in.read(buf)) > 0) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            }
            zos.close();
            mailer.setLogFilePuth(tmpFile.getPath());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.results.add(new CommandResult(cmd.getId(), CommandResultType.Error, ex.toString()));
            return;
        }
        String str = null;
        for (int i = 0; i < 5; ++i) {
            try {
                this.logger.info((Object)(LocBundle.getMessageLog((String)"rma.command.sendtry") + " = " + (i + 1)));
                mailer.send();
                str = null;
                break;
            }
            catch (Exception ex) {
                this.logger.error((Object)ex, (Throwable)ex);
                str = ex.toString();
                continue;
            }
        }
        if (str == null) {
            this.logger.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.command.succfin"), cmd));
            this.results.add(new CommandResult(cmd.getId(), CommandResultType.Ok, LocBundle.getMessageLog((String)"rma.command.succfin2")));
        } else {
            this.results.add(new CommandResult(cmd.getId(), CommandResultType.Error, str));
        }
    }

    private void updateResults() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.lastUpdate);
        ((Calendar)cal).add(12, 2);
        if (this.results.size() > 3 || this.results.size() > 0 && cal.getTime().before(new Date())) {
            try {
                this.logger.info((Object)LocBundle.getMessageLog((String)"rma.command.sendsts"));
                Response<NoResult> res = this.connector.commandResults(this.results.toArray(new CommandResult[0]));
                if (res.getServerError() == 0 && res.getServiceError() == 0) {
                    this.results = new LinkedList<CommandResult>();
                    this.lastUpdate = new Date();
                }
            }
            catch (ConnectorException ex) {
                this.logger.error((Object)ex, (Throwable)ex);
            }
        }
    }
}

