/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.agent;

import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.rma.agent.AgentListener;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.connector.ConnectorException;
import ru.softlogic.rma.connector.HeaderListener;
import ru.softlogic.rma.connector.model.Event;
import ru.softlogic.rma.connector.model.Header;
import ru.softlogic.rma.connector.model.NoResult;
import ru.softlogic.rma.connector.model.Payment;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.connector.model.Response;
import ru.softlogic.rma.connector.model.Shift;
import ru.softlogic.rma.connector.model.State;
import ru.softlogic.rma.connector.model.directory.shift.CloseShiftListener;
import ru.softlogic.rma.connector.ws.WSConnector;
import ru.softlogic.rma.persistence.CloseShift;
import ru.softlogic.rma.persistence.PersistenceException;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.persistence.ReverseOperation;
import ru.softlogic.rma.persistence.RmaEvent;
import ru.softlogic.rma.persistence.events.BaseEvent;
import ru.softlogic.rma.persistence.v2.PersistenceManager;
import ru.softlogic.rma.utils.RecordsUtils;
import ru.softlogic.rma.utils.StateUtil;
import ru.softlogic.rma.utils.ThreadUtil;

public class Agent
implements Runnable {
    private WSConnector connector;
    private long localVersion;
    private long remoteVersion = 0L;
    private final Logger log = Logger.getLogger((String)"network");
    private Set<AgentListener> listeners = new HashSet<AgentListener>();
    private Date lastConnect;
    private boolean wasError;
    private boolean sendNewPaymentsAuto;
    private boolean checkStatesAuto;
    private boolean checkBalanceAuto;
    private CloseShiftListener closeShiftListener;
    private Semaphore sendNowSemaphore = new Semaphore(1);

    public Agent(WSConnector connector, long localVersion) {
        if (connector == null) {
            throw new IllegalArgumentException("Need WSConnector");
        }
        this.connector = connector;
        this.connector.addHeaderListener(new LocalHeaderListener());
        this.localVersion = localVersion;
        this.remoteVersion = 0L;
        this.listeners = new HashSet<AgentListener>();
        this.log.setAdditivity(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)"agent's thread has been started");
        while (!Thread.currentThread().isInterrupted()) {
            try {
                PersistenceManager.getInstance();
            }
            catch (Exception ex) {
                ThreadUtil.sleep(5000L);
                continue;
            }
            try {
                this.sendNowSemaphore.acquire();
                this.pingServer();
                this.updateReferences();
                this.processEventQueue(false);
            }
            catch (ConnectorException ex) {
                this.log.error((Object)LocBundle.getMessageLog((String)"rma.agent.servconerr"), (Throwable)ex);
                this.wasError = true;
            }
            catch (Throwable ex) {
                this.log.error((Object)LocBundle.getMessageLog((String)"rma.agent.servconerr"), ex);
                this.wasError = true;
            }
            finally {
                this.sendNowSemaphore.release();
            }
            try {
                Thread.sleep(this.wasError ? 300000 : 60000);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.log.info((Object)"agent's thread has been stoped");
    }

    public void pingServer() throws ConnectorException {
        Date now = new Date();
        if (this.lastConnect == null || now.getTime() - this.lastConnect.getTime() > 60000L) {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.agent.pingserv"));
            Response<NoResult> resp = this.connector.ping();
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.agent.reqres") + " " + StateUtil.formatServerError(resp.getServerError())));
        }
    }

    public void updateReferences() throws ConnectorException {
        if (this.localVersion != this.remoteVersion && this.remoteVersion > 0L) {
            this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.agent.difvers"), this.localVersion, this.remoteVersion));
            Response<References> resp = this.connector.references(this.localVersion);
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.agent.reqres") + " " + StateUtil.formatServerError(resp.getServerError())));
            if (resp.getServerError() == 0) {
                References refs = resp.getResult();
                if (refs != null) {
                    this.localVersion = refs.getVersion();
                }
            } else {
                throw new ConnectorException("Server error");
            }
        }
    }

    public void processEventQueue(boolean sendNow) throws PersistenceException, ConnectorException {
        if (!Configuration.getInstance().getData().isSendNewPaymentsAuto() && !sendNow) {
            return;
        }
        List<BaseEvent> events = PersistenceManager.getInstance().getQueue(false, sendNow);
        if (events == null || events.isEmpty()) {
            return;
        }
        for (BaseEvent event : events) {
            switch (event.getEventType()) {
                case -1: {
                    this.processSystemEvent(event);
                    break;
                }
                case 3: {
                    this.processCloseShiftEvent(event);
                    break;
                }
                case 0: {
                    this.processOperation(event);
                    break;
                }
                case 1: {
                    this.processReverseOperationEvent(event);
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }

    public void processOperation(BaseEvent event) throws PersistenceException {
        if (event == null) {
            return;
        }
        this.log.info((Object)("\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e \u043f\u043b\u0430\u0442\u0451\u0436 " + event.getEventData()));
        Record rec = (Record)event.getEventData();
        Payment payment = RecordsUtils.rec2pay(rec);
        try {
            Response<List<State>> resp = null;
            resp = (event.getLocalState() == 0 || event.getLocalState() == 3 || event.getLocalState() == 5) && rec.getState() == 0 && rec.getSubstate() == 0 || rec.getState() == 80 && rec.getSubstate() == 2 && rec.isCanselled() ? this.connector.payment(new Payment[]{payment}) : this.connector.status(new Payment[]{payment});
            if (resp.getServerError() == 0) {
                State state = resp.getResult().get(0);
                if (state.getError() != null && state.getError() < 0) {
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.agent.setpayerr"));
                    event.setIsFinal(false);
                    event.setLocalState((short)6);
                    PersistenceManager.getInstance().updateBaseEvent(event);
                } else {
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.agent.setpaysucc"));
                    PersistenceManager.getInstance().setNormalState(state.getId(), state.getState(), state.getSubstate(), state.getError(), state.getFinalStatus(), state.getExtId(), state.getAbsState());
                    this.notifyPaymentsUpdate();
                }
            } else {
                this.log.error((Object)(LocBundle.getMessageLog((String)"rma.agent.servanverr") + " " + StateUtil.formatServerError(resp.getServerError())));
                event.setIsFinal(false);
                event.setLocalState((short)3);
                PersistenceManager.getInstance().updateBaseEvent(event);
                this.notifyPaymentsUpdate();
            }
        }
        catch (ConnectorException ex) {
            this.log.error((Object)LocBundle.getMessageLog((String)"rma.agent.erronsend"), (Throwable)ex);
            event.setIsFinal(false);
            event.setLocalState((short)6);
            PersistenceManager.getInstance().updateBaseEvent(event);
            this.notifyPaymentsUpdate();
        }
    }

    public void processReverseOperationEvent(BaseEvent event) throws PersistenceException, ConnectorException {
        if (event == null) {
            return;
        }
        this.log.info((Object)("\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e \u043e\u0442\u043c\u0435\u043d\u0443 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 id=" + ((ReverseOperation)event.getEventData()).getIdOperation()));
        Record rec = PersistenceManager.getInstance().getOperationById(((ReverseOperation)event.getEventData()).getIdOperation());
        Response<State> result = this.connector.annul(RecordsUtils.rec2pay(rec));
        if (result.getServerError() == 0) {
            if (result.getServiceError() == 0) {
                this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442");
            } else {
                this.log.error((Object)(LocBundle.getMessageLog((String)"rma.agent.paytntcanl") + " " + result.getServiceError()));
            }
            if (result.getResult() != null) {
                if (result.getResult().getError() != null && result.getResult().getError() < 0) {
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.agent.setpayerr"));
                    event.setIsFinal(false);
                    event.setLocalState((short)6);
                    PersistenceManager.getInstance().updateBaseEvent(event);
                } else {
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.agent.setpaysucc"));
                    event.setIsFinal(result.getResult().getFinalStatus() == 1);
                    event.setLocalState((short)4);
                    PersistenceManager.getInstance().updateBaseEvent(event);
                    PersistenceManager.getInstance().setNormalState(result.getResult().getId(), result.getResult().getState(), result.getResult().getSubstate(), result.getResult().getError(), result.getResult().getFinalStatus(), result.getResult().getExtId(), result.getResult().getAbsState());
                }
            }
        }
        this.notifyPaymentsUpdate();
    }

    public void processCloseShiftEvent(BaseEvent event) {
        if (event == null) {
            return;
        }
        try {
            CloseShift clShReq = (CloseShift)event.getEventData();
            Shift shift = PersistenceManager.getInstance().getShifiByIdServer(clShReq.getShiftId());
            this.log.info((Object)("\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u043c\u0435\u043d\u044b " + shift));
            Response<NoResult> closeShift = this.connector.closeShift(clShReq);
            if (closeShift.getServerError() == 0) {
                if (closeShift.getServiceError() == 0) {
                    this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442, \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u044e \u0441\u0442\u0430\u0442\u0443\u0441 \u0432 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u0431\u0430\u0437\u0435");
                    event.setIsFinal(true);
                    event.setLocalState((short)4);
                    PersistenceManager.getInstance().updateBaseEvent(event);
                    this.log.info((Object)"\u0421\u0442\u0430\u0442\u0443\u0441 \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u043e\u0431\u043d\u043e\u0432\u043b\u0451\u043d");
                    if (this.closeShiftListener != null) {
                        this.closeShiftListener.onShiftClose(true);
                    }
                } else {
                    this.log.error((Object)("\u041f\u043e\u043b\u0443\u0447\u0438\u043b \u043e\u0442\u0448\u0438\u0431\u043a\u0443 \u043e\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 code=" + closeShift.getServiceError()));
                    if (this.closeShiftListener != null) {
                        this.closeShiftListener.onShiftClose(false);
                        Shift sh = PersistenceManager.getInstance().getCurrentShift();
                        sh.setStatus((short)1);
                        PersistenceManager.getInstance().updateShift(sh);
                    }
                }
            } else {
                this.log.error((Object)("\u041f\u043e\u043b\u0443\u0447\u0438\u043b \u043e\u0448\u0438\u0431\u043a\u0443 \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0434\u043b\u044f \u0441\u043e\u0431\u044b\u0442\u0438\u044f id=" + event.getId()));
                event.setIsFinal(false);
                event.setLocalState((short)3);
                PersistenceManager.getInstance().updateBaseEvent(event);
                this.log.error((Object)"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 ");
            }
        }
        catch (Exception ex) {
            this.log.info((Object)("\u0421\u043c\u0435\u043d\u0430 \u043d\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u0430, \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0435\u0442\u0435\u0432\u043e\u043c \u0432\u0437\u0430\u0438\u043c\u043e\u0435\u0439\u0441\u0442\u0432\u0438\u0438 message=" + ex.getMessage()));
            this.closeShiftListener.onShiftClose(false);
        }
    }

    public CloseShiftListener getCloseShiftListener() {
        return this.closeShiftListener;
    }

    public void setCloseShiftListener(CloseShiftListener closeShiftListener) {
        this.closeShiftListener = closeShiftListener;
    }

    public void processSystemEvent(BaseEvent event) throws PersistenceException, ConnectorException {
        if (event == null) {
            return;
        }
        this.log.info((Object)("\u041e\u0442\u0441\u044b\u043b\u0430\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u0435 " + event));
        RmaEvent rmaEvent = (RmaEvent)event.getEventData();
        Response<NoResult> resp = this.connector.events(new Event[]{new Event(rmaEvent.getType(), rmaEvent.getComment())});
        if (resp.getServerError() == 0) {
            this.log.info((Object)"\u0421\u043e\u0431\u044b\u0442\u0438\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e, \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u044e \u0441\u0442\u0430\u0442\u0443\u0441 \u0432 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u0443\u044e \u0431\u0430\u0437\u0443");
            event.setIsFinal(true);
            event.setLocalState((short)4);
            PersistenceManager.getInstance().updateBaseEvent(event);
            this.log.info((Object)"\u0421\u0442\u0430\u0442\u0443\u0441 \u0432 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u0431\u0430\u0437\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0451\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
        }
    }

    public void setSendNewPaymentsAuto(boolean sendNewPaymentsAuto) {
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.agent.chautopay") + " " + sendNewPaymentsAuto));
        this.sendNewPaymentsAuto = sendNewPaymentsAuto;
    }

    public void setStatesAuto(boolean checkStatesAuto) {
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.agent.chautostat") + " " + checkStatesAuto));
        this.checkStatesAuto = checkStatesAuto;
    }

    public void setSendNow() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Agent.this.sendNowSemaphore.acquire();
                    Agent.this.pingServer();
                    Agent.this.updateReferences();
                    Agent.this.processEventQueue(true);
                    Agent.this.sendNowSemaphore.release();
                }
                catch (Exception ex) {
                    Agent.this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441\u0435\u0442\u0435\u0432\u043e\u0433\u043e \u0430\u0433\u0435\u043d\u0442\u0430 " + ex.getMessage()));
                }
            }
        });
    }

    public void setCheckBalanceAuto(boolean checkBalanceAuto) {
        this.checkBalanceAuto = checkBalanceAuto;
    }

    public void setLastConnect(Date lastConnect) {
        this.lastConnect = lastConnect;
    }

    private void notifyPaymentsUpdate() {
        for (AgentListener l : this.listeners) {
            l.onPaymentsUpdate();
        }
    }

    public void addListener(AgentListener agentListener) {
        if (agentListener != null) {
            this.listeners.add(agentListener);
        }
    }

    public boolean validReferences() {
        return this.localVersion == this.remoteVersion;
    }

    private class LocalHeaderListener
    implements HeaderListener {
        private LocalHeaderListener() {
        }

        @Override
        public void onHeader(Header header) {
            Agent.this.log.info((Object)(LocBundle.getMessageLog((String)"rma.agent.newhead") + " " + header));
            Agent.this.remoteVersion = header.getVersion();
            Agent.this.lastConnect = new Date();
            Agent.this.log.info((Object)(LocBundle.getMessageLog((String)"rma.agent.dirvers") + " = " + Agent.this.remoteVersion));
        }
    }
}

