/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXDatePicker;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.app.components.BalanceDialog;
import ru.softlogic.rma.app.helpers.reports.ReportListener;
import ru.softlogic.rma.connector.model.CurrentUser;
import ru.softlogic.rma.connector.model.ShiftInfo;
import ru.softlogic.rma.model.ResultShiftInfoTableModel;
import ru.softlogic.rma.model.ShiftResultMouseListener;
import ru.softlogic.rma.model.ShiftResultRenderer;
import ru.softlogic.rma.persistence.v2.PersistenceManager;
import ru.softlogic.rma.print.PrintListener;

public class RmaShiftResultBox
extends JDialog {
    JLabel notFoundLable;
    BalanceDialog balanceDialog;
    ResultShiftInfoTableModel shiftTableModel;
    LocalSearchShiftActionListener buttonActionListener;
    ShiftInfo[] shiftInfo = null;
    private ReportListener reportListener = null;
    private PrintListener printListener = null;
    private boolean visibleAllShifts = false;
    private JPanel contentPanel;
    private JPanel filterPanelPanel;
    private JXDatePicker fromDatePicker;
    private JLabel fromLabel;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JMenuItem printShiftInfoMenuItem;
    private JButton searchButton;
    private JPopupMenu shiftPopupMenu;
    private JScrollPane shiftScrollPane;
    private JLabel shiftStateLabel;
    private JTable shiftTable;
    private JMenuItem showShiftInfoMenuItem;
    private JXDatePicker toDatePicker;
    private JLabel toLabel;
    private JMenuItem toXlsShiftResultMenuItem;

    public RmaShiftResultBox(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.notFoundLable = new JLabel("\u041f\u043e \u0432\u0430\u0448\u0435\u043c\u0443 \u0437\u0430\u043f\u0440\u043e\u0441\u0443 \u043d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e!");
        this.notFoundLable.setSize(new Dimension(500, 500));
        this.notFoundLable.setHorizontalAlignment(0);
        this.notFoundLable.setName("notFoundLable");
        this.fromDatePicker.setFormats(new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd")});
        this.toDatePicker.setFormats(new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd")});
        this.buttonActionListener = new LocalSearchShiftActionListener();
        this.searchButton.addActionListener(this.buttonActionListener);
        this.shiftTableModel = new ResultShiftInfoTableModel();
        ShiftResultMouseListener sml = new ShiftResultMouseListener(this.shiftTable);
        sml.setProcessedLable(this.shiftStateLabel);
        this.shiftTable.setModel(this.shiftTableModel);
        this.shiftTable.setSelectionMode(0);
        this.shiftTable.setAutoResizeMode(1);
        this.shiftTable.setDefaultRenderer(String.class, new ShiftResultRenderer());
        this.shiftTable.setDefaultRenderer(JPanel.class, new ButtonCellRenderer());
        this.shiftTable.setDefaultEditor(JPanel.class, new ClientsTableRenderer(new JCheckBox()));
        this.shiftTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.shiftTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.shiftTable.getColumnModel().getColumn(2).setPreferredWidth(45);
        this.shiftTable.getColumnModel().getColumn(3).setPreferredWidth(45);
        this.shiftTable.getColumnModel().getColumn(4).setPreferredWidth(45);
        this.shiftTable.getColumnModel().getColumn(5).setPreferredWidth(45);
        this.shiftTable.getColumnModel().getColumn(6).setPreferredWidth(200);
        this.shiftTable.addMouseListener(sml);
        this.shiftTable.addMouseMotionListener(sml);
        this.balanceDialog = new BalanceDialog((Frame)this.getParent(), true);
    }

    public void setVisibleAllShifts(boolean visible) {
        this.visibleAllShifts = visible;
    }

    public void setReportListener(ReportListener reportListener) {
        this.reportListener = reportListener;
        if (this.balanceDialog != null) {
            this.balanceDialog.setReportListener(reportListener);
        }
    }

    public void setPrintListener(PrintListener listener) {
        this.printListener = listener;
    }

    public ActionListener getButtonActionListener() {
        return this.buttonActionListener;
    }

    private void initComponents() {
        this.shiftPopupMenu = new JPopupMenu();
        this.showShiftInfoMenuItem = new JMenuItem();
        this.printShiftInfoMenuItem = new JMenuItem();
        this.toXlsShiftResultMenuItem = new JMenuItem();
        this.contentPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.shiftStateLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.shiftScrollPane = new JScrollPane();
        this.shiftTable = new JTable();
        this.filterPanelPanel = new JPanel();
        this.searchButton = new JButton();
        this.fromDatePicker = new JXDatePicker();
        this.toDatePicker = new JXDatePicker();
        this.fromLabel = new JLabel();
        this.toLabel = new JLabel();
        this.shiftPopupMenu.setName("shiftPopupMenu");
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(RmaShiftResultBox.class);
        this.showShiftInfoMenuItem.setText(resourceMap.getString("showShiftInfoMenuItem.text", new Object[0]));
        this.showShiftInfoMenuItem.setName("showShiftInfoMenuItem");
        this.shiftPopupMenu.add(this.showShiftInfoMenuItem);
        this.printShiftInfoMenuItem.setText(resourceMap.getString("printShiftInfoMenuItem.text", new Object[0]));
        this.printShiftInfoMenuItem.setName("printShiftInfoMenuItem");
        this.shiftPopupMenu.add(this.printShiftInfoMenuItem);
        this.toXlsShiftResultMenuItem.setText(resourceMap.getString("toXlsShiftResultMenuItem.text", new Object[0]));
        this.toXlsShiftResultMenuItem.setName("toXlsShiftResultMenuItem");
        this.shiftPopupMenu.add(this.toXlsShiftResultMenuItem);
        this.setDefaultCloseOperation(2);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setMinimumSize(new Dimension(980, 560));
        this.setName("Form");
        this.contentPanel.setName("contentPanel");
        this.jPanel2.setName("jPanel2");
        this.shiftStateLabel.setName("shiftStateLabel");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel1.setPreferredSize(new Dimension(52, 14));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel1, -2, 66, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shiftStateLabel, -2, 332, -2).addContainerGap(360, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.shiftStateLabel, GroupLayout.Alignment.LEADING, -1, 20, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -2, 20, -2)).addContainerGap()));
        this.shiftScrollPane.setBorder(null);
        this.shiftScrollPane.setName("shiftScrollPane");
        this.shiftTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.shiftTable.setAutoResizeMode(4);
        this.shiftTable.setName("shiftTable");
        this.shiftTable.getTableHeader().setReorderingAllowed(false);
        this.shiftScrollPane.setViewportView(this.shiftTable);
        GroupLayout contentPanelLayout = new GroupLayout(this.contentPanel);
        this.contentPanel.setLayout(contentPanelLayout);
        contentPanelLayout.setHorizontalGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.shiftScrollPane, -1, 770, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        contentPanelLayout.setVerticalGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, contentPanelLayout.createSequentialGroup().addComponent(this.shiftScrollPane, -1, 394, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 28, -2)));
        this.filterPanelPanel.setName("filterPanelPanel");
        this.filterPanelPanel.setPreferredSize(new Dimension(776, 25));
        this.searchButton.setText(resourceMap.getString("searchButton.text", new Object[0]));
        this.searchButton.setName("searchButton");
        this.fromDatePicker.setToolTipText(resourceMap.getString("fromDatePicker.toolTipText", new Object[0]));
        this.fromDatePicker.setName("fromDatePicker");
        this.fromDatePicker.setPreferredSize(new Dimension(0, 22));
        this.toDatePicker.setToolTipText(resourceMap.getString("toDatePicker.toolTipText", new Object[0]));
        this.toDatePicker.setName("toDatePicker");
        this.toDatePicker.setPreferredSize(new Dimension(0, 22));
        this.fromLabel.setText(resourceMap.getString("fromLabel.text", new Object[0]));
        this.fromLabel.setName("fromLabel");
        this.fromLabel.setPreferredSize(new Dimension(0, 22));
        this.toLabel.setText(resourceMap.getString("toLabel.text", new Object[0]));
        this.toLabel.setName("toLabel");
        this.toLabel.setPreferredSize(new Dimension(0, 22));
        GroupLayout filterPanelPanelLayout = new GroupLayout(this.filterPanelPanel);
        this.filterPanelPanel.setLayout(filterPanelPanelLayout);
        filterPanelPanelLayout.setHorizontalGroup(filterPanelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, filterPanelPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fromLabel, -2, 16, -2).addGap(1, 1, 1).addComponent((Component)this.fromDatePicker, -2, 139, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toLabel, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.toDatePicker, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 317, Short.MAX_VALUE).addComponent(this.searchButton).addContainerGap()));
        filterPanelPanelLayout.setVerticalGroup(filterPanelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelPanelLayout.createSequentialGroup().addGroup(filterPanelPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchButton).addComponent(this.fromLabel, -2, -1, -2).addComponent((Component)this.fromDatePicker, -2, -1, -2).addComponent(this.toLabel, -2, -1, -2).addComponent((Component)this.toDatePicker, -2, 22, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filterPanelPanel, GroupLayout.Alignment.TRAILING, -1, 770, Short.MAX_VALUE).addComponent(this.contentPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.filterPanelPanel, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.contentPanel, -1, -1, Short.MAX_VALUE)));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(RmaShiftResultBox.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(RmaShiftResultBox.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(RmaShiftResultBox.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(RmaShiftResultBox.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RmaShiftResultBox dialog = new RmaShiftResultBox((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public JXDatePicker getToDatePicker() {
        return this.toDatePicker;
    }

    public JXDatePicker getFromDatePicker() {
        return this.fromDatePicker;
    }

    public class ClientsTableRenderer
    extends DefaultCellEditor {
        private JButton printButton;
        private JButton seeButton;
        private JButton registryButton;
        JPanel panel;
        private boolean clicked;
        private int row;
        private int col;
        private JTable table;

        public ClientsTableRenderer(JCheckBox checkBox) {
            super(checkBox);
            this.panel = new JPanel();
            this.seeButton = new JButton("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440");
            this.seeButton.setOpaque(true);
            this.seeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientsTableRenderer.this.fireEditingStopped();
                    if (ClientsTableRenderer.this.row >= 0) {
                        ResultShiftInfoTableModel model = (ResultShiftInfoTableModel)ClientsTableRenderer.this.table.getModel();
                        ShiftInfo info = model.getShiftInfo()[ClientsTableRenderer.this.row];
                        RmaShiftResultBox.this.balanceDialog.setShiftInfo(info);
                        RmaShiftResultBox.this.balanceDialog.setLocationRelativeTo(null);
                        RmaShiftResultBox.this.balanceDialog.setVisible(true);
                    }
                }
            });
            this.printButton = new JButton("\u041f\u0435\u0447\u0430\u0442\u044c");
            this.printButton.setOpaque(true);
            this.printButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientsTableRenderer.this.fireEditingStopped();
                    if (ClientsTableRenderer.this.row >= 0 && RmaShiftResultBox.this.printListener != null) {
                        ResultShiftInfoTableModel model = (ResultShiftInfoTableModel)ClientsTableRenderer.this.table.getModel();
                        ShiftInfo info = model.getShiftInfo()[ClientsTableRenderer.this.row];
                        RmaShiftResultBox.this.printListener.printData(info);
                    }
                }
            });
            this.registryButton = new JButton("\u0420\u0435\u0435\u0441\u0442\u0440");
            this.registryButton.setOpaque(true);
            this.registryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientsTableRenderer.this.fireEditingStopped();
                    if (ClientsTableRenderer.this.row >= 0 && RmaShiftResultBox.this.reportListener != null) {
                        ResultShiftInfoTableModel model = (ResultShiftInfoTableModel)ClientsTableRenderer.this.table.getModel();
                        ShiftInfo info = model.getShiftInfo()[ClientsTableRenderer.this.row];
                        RmaShiftResultBox.this.reportListener.generateReport(info);
                    }
                }
            });
            this.panel.setLayout(new GridLayout());
            this.panel.add(this.printButton);
            this.panel.add(this.seeButton);
            this.panel.add(this.registryButton);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.table = table;
            this.row = row;
            this.col = column;
            return this.panel;
        }

        @Override
        public Object getCellEditorValue() {
            this.clicked = false;
            return null;
        }

        @Override
        public boolean stopCellEditing() {
            this.clicked = false;
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    private class LocalSearchShiftActionListener
    implements ActionListener {
        private LocalSearchShiftActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                RmaShiftResultBox.this.contentPanel.setVisible(false);
                RmaShiftResultBox.this.notFoundLable.setVisible(false);
                RmaShiftResultBox.this.contentPanel.removeAll();
                String kassir = CurrentUser.getInstance().getUserId();
                RmaShiftResultBox.this.shiftInfo = PersistenceManager.getInstance().getShiftInfo(kassir, RmaShiftResultBox.this.fromDatePicker.getDate(), RmaShiftResultBox.this.toDatePicker.getDate(), RmaShiftResultBox.this.visibleAllShifts);
                if (RmaShiftResultBox.this.shiftInfo == null || RmaShiftResultBox.this.shiftInfo.length <= 0) {
                    RmaShiftResultBox.this.contentPanel.setLayout(new BorderLayout());
                    RmaShiftResultBox.this.contentPanel.add((Component)RmaShiftResultBox.this.notFoundLable, "Center");
                    RmaShiftResultBox.this.notFoundLable.setSize(new Dimension(500, 500));
                    RmaShiftResultBox.this.notFoundLable.setVisible(true);
                } else {
                    RmaShiftResultBox.this.shiftTableModel.setShiftsInfo(RmaShiftResultBox.this.shiftInfo);
                    GroupLayout contentPanelLayout = new GroupLayout(RmaShiftResultBox.this.contentPanel);
                    RmaShiftResultBox.this.contentPanel.setLayout(contentPanelLayout);
                    contentPanelLayout.setHorizontalGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(RmaShiftResultBox.this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(RmaShiftResultBox.this.shiftScrollPane, -1, 893, Short.MAX_VALUE));
                    contentPanelLayout.setVerticalGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, contentPanelLayout.createSequentialGroup().addComponent(RmaShiftResultBox.this.shiftScrollPane, -1, 445, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(RmaShiftResultBox.this.jPanel2, -2, 22, -2)));
                }
                RmaShiftResultBox.this.contentPanel.setVisible(true);
            }
            catch (Exception ex) {
                org.apache.log4j.Logger.getLogger((String)"persistance").error((Object)ex.getMessage());
            }
        }
    }

    public class ButtonCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            JPanel panel = new JPanel();
            panel.setSize(new Dimension(120, 30));
            panel.setLayout(new GridLayout());
            panel.add(new JButton("\u041f\u0435\u0447\u0430\u0442\u044c"));
            panel.add(new JButton("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440"));
            panel.add(new JButton("\u0420\u0435\u0435\u0441\u0442\u0440"));
            return panel;
        }
    }
}

