/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXDatePicker;
import rmai18n.LocBundle;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.RmaReportBoxListener;

public class RmaReportBox
extends JDialog {
    private Set<RmaReportBoxListener> listeners;
    private JLabel StateLabel;
    private JXDatePicker beginDatePicker;
    private JLabel beginLabel;
    private JButton cancelButton;
    private JXDatePicker endDatePicker;
    private JLabel endLabel;
    private JButton okButton;
    private JCheckBox payErrorCheckBox;
    private JCheckBox payNewCheckBox;
    private JCheckBox payProcessedCheckBox;
    private JCheckBox paySuccessCheckBox;

    public RmaReportBox(Frame parent) {
        super(parent);
        this.initComponents();
        this.cancelButton.addActionListener(new CancelListener());
        this.okButton.addActionListener(new ProcessListener());
        this.getRootPane().setDefaultButton(this.okButton);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmaReportBox.this.cancelButton.doClick();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        this.beginDatePicker.setDate(cal.getTime());
        this.endDatePicker.setDate(cal.getTime());
        this.listeners = new HashSet<RmaReportBoxListener>();
        this.paySuccessCheckBox.setSelected(true);
    }

    private void initComponents() {
        this.beginDatePicker = new JXDatePicker();
        this.endDatePicker = new JXDatePicker();
        this.beginLabel = new JLabel();
        this.endLabel = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.StateLabel = new JLabel();
        this.paySuccessCheckBox = new JCheckBox();
        this.payProcessedCheckBox = new JCheckBox();
        this.payNewCheckBox = new JCheckBox();
        this.payErrorCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(RmaReportBox.class);
        this.setTitle(resourceMap.getString("RmaReportBox.Form.title", new Object[0]));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.beginDatePicker.setRequestFocusEnabled(false);
        this.endDatePicker.setRequestFocusEnabled(false);
        this.beginLabel.setHorizontalAlignment(4);
        this.beginLabel.setText(resourceMap.getString("RmaReportBox.beginLabel.text", new Object[0]));
        this.endLabel.setHorizontalAlignment(4);
        this.endLabel.setText(resourceMap.getString("RmaReportBox.endLabel.text", new Object[0]));
        this.okButton.setText(resourceMap.getString("action.form", new Object[0]));
        this.cancelButton.setText(resourceMap.getString("action.cancel", new Object[0]));
        this.StateLabel.setText(resourceMap.getString("RmaReportBox.stateLabel.text", new Object[0]));
        this.paySuccessCheckBox.setText(resourceMap.getString("RmaReportBox.paySuccessCheckBox.text", new Object[0]));
        this.payProcessedCheckBox.setText(resourceMap.getString("RmaReportBox.payProcessedCheckBox.text", new Object[0]));
        this.payNewCheckBox.setText(resourceMap.getString("RmaReportBox.payNewCheckBox.text", new Object[0]));
        this.payErrorCheckBox.setText(resourceMap.getString("RmaReportBox.payErrorCheckBox.text", new Object[0]));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.beginLabel, -1, 128, Short.MAX_VALUE).addComponent(this.endLabel, -1, 128, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.beginDatePicker, -1, 164, Short.MAX_VALUE).addComponent((Component)this.endDatePicker, -1, 164, Short.MAX_VALUE))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.StateLabel).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.payProcessedCheckBox).addComponent(this.paySuccessCheckBox)))).addGap(176, 176, 176)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.payNewCheckBox).addComponent(this.payErrorCheckBox)).addGap(37, 37, 37)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cancelButton).addGap(7, 7, 7).addComponent(this.okButton)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.beginDatePicker, -2, -1, -2).addComponent(this.beginLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.endDatePicker, -2, -1, -2).addComponent(this.endLabel)).addGap(18, 18, 18).addComponent(this.StateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.payNewCheckBox).addComponent(this.paySuccessCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.payErrorCheckBox).addComponent(this.payProcessedCheckBox)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, new Component[]{this.beginDatePicker, this.beginLabel, this.endDatePicker, this.endLabel});
        this.pack();
    }

    public void addListener(RmaReportBoxListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (RmaReportBoxListener rrbl : RmaReportBox.this.listeners) {
                rrbl.onExit();
            }
        }
    }

    private class ProcessListener
    implements ActionListener {
        private ProcessListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RmaReportBox.this.beginDatePicker.getDate() == null) {
                RmaReportBox.this.beginDatePicker.requestFocus();
                JOptionPane.showMessageDialog(RmaReportBox.this, LocBundle.getMessage((String)"rma.report.startdnt"), LocBundle.getMessage((String)"error"), 0);
                return;
            }
            if (RmaReportBox.this.endDatePicker.getDate() == null) {
                RmaReportBox.this.endDatePicker.requestFocus();
                JOptionPane.showMessageDialog(RmaReportBox.this, LocBundle.getMessage((String)"rma.report.enddnt"), LocBundle.getMessage((String)"error"), 0);
                return;
            }
            if (RmaReportBox.this.endDatePicker.getDate().before(RmaReportBox.this.beginDatePicker.getDate())) {
                RmaReportBox.this.endDatePicker.requestFocus();
                JOptionPane.showMessageDialog(RmaReportBox.this, LocBundle.getMessage((String)"rma.report.eqdate"), LocBundle.getMessage((String)"error"), 0);
                return;
            }
            for (RmaReportBoxListener rrbl : RmaReportBox.this.listeners) {
                rrbl.onProcess(RmaReportBox.this.beginDatePicker.getDate(), RmaReportBox.this.endDatePicker.getDate(), RmaReportBox.this.payNewCheckBox.isSelected(), RmaReportBox.this.payProcessedCheckBox.isSelected(), RmaReportBox.this.payErrorCheckBox.isSelected(), RmaReportBox.this.paySuccessCheckBox.isSelected());
            }
        }
    }
}

