/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import rmai18n.LocBundle;
import ru.softlogic.rma.RmaNavigatePanelLintener;

public class RmaNavigatePanel
extends JPanel {
    private int pageSize;
    private int curPage;
    private int itemsCount;
    private RmaNavigatePanelLintener navListener;
    private JButton goFirst;
    private JButton goLast;
    private TableLayout layout;

    public RmaNavigatePanel() {
        this.initComponents();
        this.layout = new TableLayout(new double[0], new double[]{20.0});
        this.setLayout((LayoutManager)this.layout);
        this.curPage = 1;
        this.pageSize = 30;
        this.goFirst = new JButton("<<");
        this.goFirst.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmaNavigatePanel.this.setCurPage(1);
            }
        });
        this.goLast = new JButton(">>");
        this.goLast.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmaNavigatePanel.this.setCurPage(RmaNavigatePanel.this.getMaxPageNum());
            }
        });
        this.navigateReBuild();
    }

    private void initComponents() {
        this.setName("Form");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 480, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 34, Short.MAX_VALUE));
    }

    public int getCurPage() {
        return this.curPage;
    }

    public int getCurStartNumber() {
        return (this.getCurPage() - 1) * this.getPageSize();
    }

    public int getItemsCount() {
        return this.itemsCount;
    }

    public RmaNavigatePanelLintener getNavListener() {
        return this.navListener;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setCurPage(int curPage) {
        int prevVal = this.curPage;
        int maxPages = this.getMaxPageNum();
        if (curPage >= 1 && curPage <= maxPages) {
            this.curPage = curPage;
        } else if (curPage < 1) {
            this.curPage = 1;
        } else if (curPage > maxPages) {
            this.curPage = maxPages;
        }
        this.navigateReBuild();
        if (this.navListener != null) {
            this.navListener.curPageChange(prevVal);
            this.navListener.navigateAnyChange();
        }
    }

    public void setItemsCount(int itemsCount) {
        int prevVal = this.itemsCount;
        this.itemsCount = itemsCount > 0 ? itemsCount : 1;
        this.navigateReBuild();
        if (this.navListener != null) {
            this.navListener.itemsCountChange(prevVal);
            this.navListener.navigateAnyChange();
        }
        this.setCurPage(1);
    }

    public void setNavListener(RmaNavigatePanelLintener navListener) {
        this.navListener = navListener;
    }

    public void setPageSize(int pageSize) {
        int prevVal = this.pageSize;
        this.pageSize = pageSize > 0 ? pageSize : 1;
        this.navigateReBuild();
        if (this.navListener != null) {
            this.navListener.pageSizeChange(prevVal);
            this.navListener.navigateAnyChange();
        }
    }

    private void navigateReBuild() {
        ArrayList<JLabel> coms = new ArrayList<JLabel>();
        NavigateLabelMauseListener listener = new NavigateLabelMauseListener();
        JLabel cur = new JLabel("<html><font color='black'>" + this.getCurPage() + "</font></html>");
        cur.addMouseListener(listener);
        coms.add(cur);
        int max = this.getMaxPageNum();
        for (int i = 0; i < 7; ++i) {
            JLabel lab;
            if (max - this.getCurPage() > i && this.getCurPage() + i + 1 != 1 && this.getCurPage() + i + 1 != max) {
                lab = new JLabel("<html><font color='blue' size=3><u>" + (this.getCurPage() + i + 1) + "</u></font></html>");
                lab.putClientProperty("numb", new Integer(this.getCurPage() + i + 1));
                lab.setCursor(new Cursor(12));
                lab.addMouseListener(listener);
                coms.add(lab);
            }
            if (this.getCurPage() - i > 1 && this.getCurPage() - i - 1 != 1 && this.getCurPage() - i - 1 != max) {
                lab = new JLabel("<html><font color='blue' size=3><u>" + (this.getCurPage() - i - 1) + "</u></font></html>");
                lab.putClientProperty("numb", new Integer(this.getCurPage() - i - 1));
                lab.setCursor(new Cursor(12));
                lab.addMouseListener(listener);
                coms.add(0, lab);
            }
            if (this.getCurPage() == 1 || this.getCurPage() == max ? coms.size() > 7 : coms.size() > 6) break;
        }
        if (this.getCurPage() != 1) {
            JLabel lab = new JLabel("<html><font color='blue' size=3><u>1</u></font></html>");
            lab.putClientProperty("numb", new Integer(1));
            lab.setCursor(new Cursor(12));
            lab.addMouseListener(listener);
            coms.add(0, lab);
        }
        if (max != 1 && max != this.getCurPage()) {
            JLabel lab = new JLabel("<html><font color='blue' size=3><u>" + max + "</u></font></html>");
            lab.putClientProperty("numb", new Integer(max));
            lab.setCursor(new Cursor(12));
            lab.addMouseListener(listener);
            coms.add(lab);
        }
        double[] size = new double[2 + 2 * coms.size()];
        size[0] = -1.0;
        size[1] = 70.0;
        for (int i = 2; i < size.length; ++i) {
            size[i] = 5.0;
            size[i + 1] = -2.0;
            ++i;
        }
        this.removeAll();
        JLabel pg = new JLabel(LocBundle.getMessage((String)"rma.navigate.page"));
        this.add((Component)pg, "1,0");
        this.layout.setColumn(size);
        for (int i = 0; i < coms.size(); ++i) {
            this.add((Component)coms.get(i), 2 * (i + 1) + 1 + ",0");
        }
        this.validate();
    }

    public int getMaxPageNum() {
        if (this.getItemsCount() == 0) {
            return 1;
        }
        return this.getItemsCount() % this.getPageSize() == 0 ? this.getItemsCount() / this.getPageSize() : this.getItemsCount() / this.getPageSize() + 1;
    }

    private class NavigateLabelMauseListener
    implements MouseListener {
        private NavigateLabelMauseListener() {
        }

        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() instanceof JLabel) {
                JLabel lab = (JLabel)e.getSource();
                Integer page = (Integer)lab.getClientProperty("numb");
                if (page == null) {
                    return;
                }
                RmaNavigatePanel.this.setCurPage(page);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class NavigateButtonActionListener
    implements ActionListener {
        private NavigateButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JToggleButton) {
                JToggleButton but = (JToggleButton)e.getSource();
                Integer page = (Integer)but.getClientProperty("numb");
                if (page == null) {
                    return;
                }
                RmaNavigatePanel.this.setCurPage(page);
                but.setSelected(true);
            } else if (e.getSource() instanceof JButton) {
                JButton but = (JButton)e.getSource();
                Integer page = (Integer)but.getClientProperty("numb");
                if (page == null) {
                    return;
                }
                RmaNavigatePanel.this.setCurPage(page);
            }
        }
    }
}

