/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.RmaLoginBoxListener;

public class RmaLoginBox
extends JDialog {
    private Set<RmaLoginBoxListener> listeners;
    private JButton closeButton;
    private JButton configureAppButton;
    private JButton enterButton;
    private JLabel invitationLabel;
    private JLabel invitationLabel1;
    private JPanel jPanel1;
    private JTextField loginField;
    private JPasswordField passwordField;

    public RmaLoginBox(Frame parent, String login) {
        super(parent, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.enterButton);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmaLoginBox.this.closeButton.doClick(1);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.loginField.setText(login);
        this.loginField.requestFocus();
        this.passwordField.setText("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RmaLoginBox.this.closeButton.doClick();
            }
        });
        this.listeners = new HashSet<RmaLoginBoxListener>();
    }

    public void addListener(RmaLoginBoxListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void setVisible(boolean flag) {
        this.passwordField.setText("");
        super.setVisible(flag);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.enterButton = new JButton();
        this.closeButton = new JButton();
        this.passwordField = new JPasswordField();
        this.invitationLabel = new JLabel();
        this.invitationLabel1 = new JLabel();
        this.loginField = new JTextField();
        this.configureAppButton = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(RmaLoginBox.class);
        this.setTitle(resourceMap.getString("LoginBox.title", new Object[0]));
        this.setModal(true);
        this.setResizable(false);
        this.jPanel1.setOpaque(false);
        ApplicationActionMap actionMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getActionMap(RmaLoginBox.class, (Object)this);
        this.enterButton.setAction(actionMap.get("login"));
        this.enterButton.setText(resourceMap.getString("action.login", new Object[0]));
        this.closeButton.setAction(actionMap.get("exit"));
        this.closeButton.setText(resourceMap.getString("action.close", new Object[0]));
        this.passwordField.setText("12345678");
        this.invitationLabel.setText(resourceMap.getString("RmaLoginBox.invitationLabel.text", new Object[0]));
        this.invitationLabel1.setText(resourceMap.getString("LoginBox.invitationLogin.text", new Object[0]));
        this.loginField.setText(resourceMap.getString("loginField.text", new Object[0]));
        this.configureAppButton.setAction(actionMap.get("configure"));
        this.configureAppButton.setIcon(resourceMap.getIcon("configureAppButton.icon"));
        this.configureAppButton.setText(resourceMap.getString("configureAppButton.text", new Object[0]));
        this.configureAppButton.setToolTipText(resourceMap.getString("configureAppButton.toolTipText", new Object[0]));
        this.configureAppButton.setBorder(BorderFactory.createCompoundBorder());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.invitationLabel1).addComponent(this.invitationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loginField, -1, 258, Short.MAX_VALUE).addComponent(this.passwordField, -1, 258, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.configureAppButton, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 78, Short.MAX_VALUE).addComponent(this.enterButton).addGap(18, 18, 18).addComponent(this.closeButton).addGap(22, 22, 22)))));
        jPanel1Layout.linkSize(0, this.closeButton, this.enterButton);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.invitationLabel1).addComponent(this.loginField, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.invitationLabel).addComponent(this.passwordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 26, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.enterButton)).addComponent(this.configureAppButton, -2, 33, -2)).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RmaLoginBox dialog = new RmaLoginBox((Frame)new JFrame(), "");
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    @Action
    public void login() {
        for (RmaLoginBoxListener l : this.listeners) {
            l.onLogin(this.loginField.getText(), this.passwordField.getText());
        }
    }

    @Action
    public void configure() {
        for (RmaLoginBoxListener each : this.listeners) {
            each.onConfigureApp();
        }
    }

    @Action
    public void exit() {
        this.setVisible(false);
        for (RmaLoginBoxListener l : this.listeners) {
            l.onExit();
        }
    }
}

