/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXTitledSeparator;
import rmai18n.LocBundle;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.app.components.RoundedBorder;
import ru.softlogic.rma.connector.model.Commission;
import ru.softlogic.rma.connector.model.CommissionType;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.Service;
import ru.softlogic.rma.model.CommissionTableModel;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.utils.SumFormatter;

public class RmaInfoPanel
extends JPanel {
    private CommissionTableModel commissionTableModel;
    private final Border border = new RoundedBorder(2, 3, 2, 3);
    private JXTitledSeparator commissionSeparator;
    private JLabel defaultPercent;
    private JLabel defaultPercentLabel;
    private JLabel defaultSum;
    private JLabel defaultSumLabel;
    private JLabel maxCommission;
    private JLabel maxCommissionLabel;
    private JLabel maxSum;
    private JLabel maxSumLabel;
    private JLabel minCommission;
    private JLabel minCommissionLabel;
    private JLabel minSum;
    private JLabel minSumLabel;
    private JPanel paymentsPanel;
    private JXTitledSeparator paymentsSeparator;
    private JLabel round;
    private JLabel roundLabel;
    private JLabel serviceNumber;
    private JLabel serviceNumberLabel;
    private JXTitledSeparator serviceSeparator;
    private JXTitledSeparator stepSeparator;
    private JScrollPane stepsScrollPanel;
    private JTable stepsTable;
    private JLabel type;
    private JLabel typeLabel;

    public RmaInfoPanel() {
        this.initComponents();
        this.stepsTable.setSelectionMode(0);
        this.commissionTableModel = new CommissionTableModel();
        this.stepsTable.setModel(this.commissionTableModel);
    }

    public void init(MenuItem menuItem) {
        if (menuItem != null) {
            String empty = "-";
            Service srv = menuItem.getService();
            this.serviceNumberLabel.setText(Short.toString(srv.getId()));
            this.minSumLabel.setText(srv.getMinSum() == null || srv.getMinSum() == 0 ? empty : SumFormatter.format(srv.getMinSum()));
            this.maxSumLabel.setText(srv.getMaxSum() == null || srv.getMaxSum() == 0 ? empty : SumFormatter.format(srv.getMaxSum()));
            Commission comm = menuItem.getCommission();
            this.typeLabel.setText(comm.getType() == CommissionType.Direct ? LocBundle.getMessage((String)"rma.info.direct") : LocBundle.getMessage((String)"rma.info.revert"));
            this.minCommissionLabel.setText(comm.getMin() == null || comm.getMin() == 0 ? empty : SumFormatter.format(comm.getMin()));
            this.maxCommissionLabel.setText(comm.getMax() == null || comm.getMax() == 0 ? empty : SumFormatter.format(comm.getMax()));
            this.roundLabel.setText(comm.getRoundOrder() == null ? empty : Integer.toString(comm.getRoundOrder()));
            this.defaultPercentLabel.setText(SumFormatter.format(comm.getPercentValue()));
            this.defaultSumLabel.setText(SumFormatter.format(comm.getFixedValue()));
            if (comm.getSteps() != null && comm.getSteps().size() > 0) {
                this.commissionTableModel.setSteps(comm.getSteps());
                this.stepsScrollPanel.setVisible(true);
                this.stepSeparator.setVisible(true);
            } else {
                this.stepsScrollPanel.setVisible(false);
                this.stepSeparator.setVisible(false);
            }
            this.paymentsPanel.setVisible(false);
            this.paymentsSeparator.setVisible(false);
        }
    }

    public void initPayments(Record[] records) {
    }

    private void initComponents() {
        this.serviceNumber = new JLabel();
        this.serviceNumberLabel = new JLabel();
        this.minSum = new JLabel();
        this.minSumLabel = new JLabel();
        this.maxSum = new JLabel();
        this.maxSumLabel = new JLabel();
        this.serviceSeparator = new JXTitledSeparator();
        this.commissionSeparator = new JXTitledSeparator();
        this.type = new JLabel();
        this.typeLabel = new JLabel();
        this.minCommission = new JLabel();
        this.minCommissionLabel = new JLabel();
        this.maxCommission = new JLabel();
        this.maxCommissionLabel = new JLabel();
        this.round = new JLabel();
        this.roundLabel = new JLabel();
        this.defaultPercent = new JLabel();
        this.defaultPercentLabel = new JLabel();
        this.defaultSum = new JLabel();
        this.defaultSumLabel = new JLabel();
        this.stepsScrollPanel = new JScrollPane();
        this.stepsTable = new JTable();
        this.stepSeparator = new JXTitledSeparator();
        this.paymentsSeparator = new JXTitledSeparator();
        this.paymentsPanel = new JPanel();
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.serviceNumber.setFont(new Font("Tahoma", 1, 11));
        this.serviceNumber.setHorizontalAlignment(4);
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(RmaInfoPanel.class);
        this.serviceNumber.setText(resourceMap.getString("RmaInfoPanel.serviceNumber.text", new Object[0]));
        this.serviceNumberLabel.setText("jLabel2");
        this.minSum.setFont(new Font("Tahoma", 1, 11));
        this.minSum.setHorizontalAlignment(4);
        this.minSum.setText(resourceMap.getString("RmaInfoPanel.minSum.text", new Object[0]));
        this.minSumLabel.setText("jLabel4");
        this.maxSum.setFont(new Font("Tahoma", 1, 11));
        this.maxSum.setHorizontalAlignment(4);
        this.maxSum.setText(resourceMap.getString("RmaInfoPanel.maxSum.text", new Object[0]));
        this.maxSumLabel.setText("jLabel6");
        this.serviceSeparator.setTitle(resourceMap.getString("RmaInfoPanel.serviceSeparator.title", new Object[0]));
        this.commissionSeparator.setTitle(resourceMap.getString("RmaInfoPanel.commissionSeparator.title", new Object[0]));
        this.type.setFont(new Font("Tahoma", 1, 11));
        this.type.setText(resourceMap.getString("RmaInfoPanel.type.text", new Object[0]));
        this.typeLabel.setText("jLabel13");
        this.minCommission.setFont(new Font("Tahoma", 1, 11));
        this.minCommission.setText(resourceMap.getString("RmaInfoPanel.minCommission.text", new Object[0]));
        this.minCommissionLabel.setText("jLabel14");
        this.maxCommission.setFont(new Font("Tahoma", 1, 11));
        this.maxCommission.setText(resourceMap.getString("RmaInfoPanel.maxCommission.text", new Object[0]));
        this.maxCommissionLabel.setText("jLabel15");
        this.round.setFont(new Font("Tahoma", 1, 11));
        this.round.setText(resourceMap.getString("RmaInfoPanel.round.text", new Object[0]));
        this.roundLabel.setText("jLabel16");
        this.defaultPercent.setFont(new Font("Tahoma", 1, 11));
        this.defaultPercent.setText(resourceMap.getString("RmaInfoPanel.defaultPercent.text", new Object[0]));
        this.defaultPercentLabel.setText("jLabel17");
        this.defaultSum.setFont(new Font("Tahoma", 1, 11));
        this.defaultSum.setText(resourceMap.getString("RmaInfoPanel.defaultSum.text", new Object[0]));
        this.defaultSumLabel.setText("jLabel18");
        this.stepsTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.stepsTable.setFocusable(false);
        this.stepsTable.getTableHeader().setReorderingAllowed(false);
        this.stepsScrollPanel.setViewportView(this.stepsTable);
        this.stepSeparator.setTitle(resourceMap.getString("RmaInfoPanel.stepSeparator.title", new Object[0]));
        this.paymentsSeparator.setTitle(resourceMap.getString("RmaView.paymentPanel", new Object[0]));
        this.paymentsPanel.setMinimumSize(new Dimension(22, 10));
        this.paymentsPanel.setLayout(new FlowLayout(0));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.paymentsPanel, -1, 245, Short.MAX_VALUE).addComponent((Component)this.paymentsSeparator, -1, 245, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultPercent, GroupLayout.Alignment.TRAILING).addComponent(this.defaultSum, GroupLayout.Alignment.TRAILING).addComponent(this.type, GroupLayout.Alignment.TRAILING).addComponent(this.round, GroupLayout.Alignment.TRAILING).addComponent(this.minCommission, GroupLayout.Alignment.TRAILING).addComponent(this.maxCommission, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultSumLabel, -1, 113, Short.MAX_VALUE).addComponent(this.defaultPercentLabel, -1, 113, Short.MAX_VALUE).addComponent(this.roundLabel, -1, 113, Short.MAX_VALUE).addComponent(this.maxCommissionLabel, -1, 113, Short.MAX_VALUE).addComponent(this.minCommissionLabel, -1, 113, Short.MAX_VALUE).addComponent(this.typeLabel, -1, 113, Short.MAX_VALUE))).addComponent((Component)this.commissionSeparator, -1, 245, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.serviceNumber, GroupLayout.Alignment.TRAILING, -1, 123, Short.MAX_VALUE).addComponent(this.minSum, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.maxSum, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maxSumLabel, -1, 66, Short.MAX_VALUE).addComponent(this.serviceNumberLabel, -1, 66, Short.MAX_VALUE).addComponent(this.minSumLabel, -1, 66, Short.MAX_VALUE)).addGap(50, 50, 50)).addComponent((Component)this.serviceSeparator, -1, 245, Short.MAX_VALUE).addComponent(this.stepsScrollPanel, GroupLayout.Alignment.TRAILING, -1, 245, Short.MAX_VALUE).addComponent((Component)this.stepSeparator, -1, 245, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.paymentsSeparator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paymentsPanel, -2, 134, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.serviceSeparator, -2, -1, -2).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.serviceNumberLabel).addComponent(this.serviceNumber)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.minSum).addComponent(this.minSumLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.maxSumLabel).addComponent(this.maxSum)).addGap(18, 18, 18).addComponent((Component)this.commissionSeparator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.type).addComponent(this.typeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minCommission).addComponent(this.minCommissionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxCommission).addComponent(this.maxCommissionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.round).addComponent(this.roundLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultPercent).addComponent(this.defaultPercentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultSum).addComponent(this.defaultSumLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.stepSeparator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stepsScrollPanel, -2, 87, -2).addContainerGap(30, Short.MAX_VALUE)));
        layout.linkSize(1, this.maxSum, this.maxSumLabel, this.minSum, this.minSumLabel, this.serviceNumber, this.serviceNumberLabel);
    }
}

