/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma;

import java.awt.AWTKeyStroke;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import rmai18n.LocBundle;
import ru.softlogic.rma.ComboItem;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.app.docs.LetterNumberDocument;
import ru.softlogic.rma.app.docs.SumDocument;
import ru.softlogic.rma.print.queue.DocumentData;
import ru.softlogic.rma.print.queue.DocumentType;
import ru.softlogic.rma.print.queue.PrinterQueue;

public class RmaCustomDocument
extends JDialog {
    private PrinterQueue queue;
    private JButton cancelButton;
    private JLabel goodNameLabel;
    private JTextField goodNameTextField;
    private JButton okButton;
    private JLabel sumLabel;
    private JTextField sumTextField;
    private JComboBox typeComboBox;
    private JLabel typeLabel;

    public RmaCustomDocument(Frame owner, PrinterQueue queue) {
        super(owner);
        if (queue == null) {
            throw new IllegalArgumentException("Need PrinterQueue");
        }
        this.initComponents();
        this.queue = queue;
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmaCustomDocument.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
        forwardKeys.add(KeyStroke.getKeyStroke(10, 0));
        this.typeComboBox.setFocusTraversalKeys(0, forwardKeys);
        this.goodNameTextField.setFocusTraversalKeys(0, forwardKeys);
        this.sumTextField.setFocusTraversalKeys(0, forwardKeys);
        ComboItem[] items = new ComboItem[]{new ComboItem(DocumentType.Sale, LocBundle.getMessage((String)"rma.custom.anysell")), new ComboItem(DocumentType.Return, LocBundle.getMessage((String)"rma.custom.return"))};
        this.typeComboBox.setModel(new DefaultComboBoxModel<ComboItem>(items));
        this.sumTextField.setDocument(new SumDocument());
        this.goodNameTextField.setDocument(new LetterNumberDocument(30));
    }

    public void init() {
        this.typeComboBox.setSelectedItem(null);
        this.sumTextField.setText("");
        this.goodNameTextField.setText("");
    }

    private void initComponents() {
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.goodNameLabel = new JLabel();
        this.goodNameTextField = new JTextField();
        this.sumLabel = new JLabel();
        this.sumTextField = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(RmaCustomDocument.class);
        this.setTitle(resourceMap.getString("RmaCustomDocument.Form.title", new Object[0]));
        this.setResizable(false);
        this.typeLabel.setText(resourceMap.getString("RmaCustomDocument.typeLabel.text", new Object[0]));
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.goodNameLabel.setText(resourceMap.getString("RmaCustomDocument.goodNameLabel.text", new Object[0]));
        this.goodNameTextField.setText("jTextField1");
        this.sumLabel.setText(resourceMap.getString("RmaCustomDocument.sumLabel.text", new Object[0]));
        this.sumTextField.setText("jTextField2");
        this.okButton.setText(resourceMap.getString("action.exec", new Object[0]));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaCustomDocument.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(resourceMap.getString("action.cancel", new Object[0]));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmaCustomDocument.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.sumLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.goodNameLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.typeLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sumTextField, -1, 287, Short.MAX_VALUE).addComponent(this.goodNameTextField, -1, 287, Short.MAX_VALUE).addComponent(this.typeComboBox, 0, 287, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLabel).addComponent(this.typeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.goodNameLabel).addComponent(this.goodNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sumLabel).addComponent(this.sumTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 33, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.typeComboBox.getSelectedItem() == null) {
            this.typeComboBox.requestFocus();
            JOptionPane.showMessageDialog(this, LocBundle.getMessage((String)"rma.custom.notseltype"), LocBundle.getMessage((String)"rma.custom.erratrchk"), 0);
            return;
        }
        int sum = 0;
        try {
            sum = Integer.parseInt(this.sumTextField.getText());
            if (sum <= 0) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            this.sumTextField.requestFocus();
            JOptionPane.showMessageDialog(this, LocBundle.getMessage((String)"rma.custom.errsum"), LocBundle.getMessage((String)"rma.custom.erratrchk"), 0);
            return;
        }
        ComboItem ci = (ComboItem)this.typeComboBox.getSelectedItem();
        if (JOptionPane.showConfirmDialog(this, LocBundle.getMessage((String)"rma.custom.aploper"), "", 0) == 0) {
            DocumentData data = new DocumentData();
            data.setCount(1);
            data.setSum(sum * 100);
            data.setName(this.goodNameTextField.getText());
            data.setType(ci.getType());
            this.queue.addDocument(data);
            this.setVisible(false);
        }
    }
}

