/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import rmai18n.LocBundle;
import ru.softlogic.rma.RmaAppContext;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.connector.model.Shift;
import ru.softlogic.rma.model.keeperpayments.KeeperPayment;
import ru.softlogic.rma.persistence.PersistenceException;
import ru.softlogic.rma.persistence.v2.PersistenceManager;

public class RmaAppExitListener
implements Application.ExitListener {
    private Logger log = Logger.getLogger((String)"app");
    private RmaAppContext context;
    private Thread agentThread;

    public RmaAppExitListener(RmaAppContext context, Thread agentThread) {
        this.log.setAdditivity(false);
        this.context = context;
        this.agentThread = agentThread;
    }

    public boolean canExit(EventObject event) {
        if (event != null) {
            boolean check = Configuration.getInstance().getData().isCheckNewPaymentsOnExit();
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.exit") + " " + check));
            if (check) {
                try {
                    Component source = (Component)event.getSource();
                    boolean isCartNotEmpti = !KeeperPayment.getInstanse().isEmpty();
                    this.log.info((Object)("\u041d\u0435\u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d\u043d\u044b\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u0432 \u043a\u043e\u0440\u0437\u0438\u043d\u0435 " + isCartNotEmpti));
                    if (isCartNotEmpti) {
                        JOptionPane.showMessageDialog(this.context.getMainFrame(), "\u0412 \u043a\u043e\u0440\u0437\u0438\u043d\u0435 \u0438\u043c\u0435\u044e\u0442\u0441\u044f \u043d\u0435\u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d\u043d\u044b\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438!", LocBundle.getMessage((String)"error"), 0);
                        return false;
                    }
                    Shift currentShift = PersistenceManager.getInstance().getCurrentShift();
                    if (currentShift != null && currentShift.getStatus() == 0) {
                        boolean ok;
                        boolean bl = ok = JOptionPane.showConfirmDialog(this.context.getMainFrame(), "\u0418\u043c\u0435\u0435\u0442\u0441\u044f \u043d\u0435\u0437\u0430\u043a\u0440\u044b\u0442\u0430\u044f \u0441\u043c\u0435\u043d\u0430, \u0417\u0430\u043a\u0440\u044b\u0442\u044c?", "\u0418\u043c\u0435\u0435\u0442\u0441\u044f \u043d\u0435\u0437\u0430\u043a\u0440\u044b\u0442\u0430\u044f \u0441\u043c\u0435\u043d\u0430!", 0) == 0;
                        if (ok) {
                            if (this.context != null) {
                                this.context.closeShift();
                            }
                            return false;
                        }
                    }
                    boolean have = PersistenceManager.getInstance().validEventQueue();
                    this.log.info((Object)(LocBundle.getMessageLog((String)"rma.exitpayments") + " " + have));
                    if (have) {
                        boolean exit = JOptionPane.showConfirmDialog(source, LocBundle.getMessage((String)"rma.doexit")) == 0;
                        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.userexit") + " " + exit));
                        return exit;
                    }
                }
                catch (PersistenceException ex) {
                    this.log.error((Object)LocBundle.getMessageLog((String)"rma.dbworkerror"), (Throwable)ex);
                }
            }
        }
        if (this.agentThread != null) {
            this.agentThread.interrupt();
        }
        return true;
    }

    public void willExit(EventObject event) {
    }
}

