/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma;

import java.awt.Window;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.View;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import rmai18n.LocBundle;
import ru.softlogic.input.model.advanced.configuration.RuntimeConfiguration;
import ru.softlogic.input.model.advanced.configuration.SoftwareType;
import ru.softlogic.input.model.advanced.messages.B;
import ru.softlogic.parser.ParseElementSearcher;
import ru.softlogic.parser.uni.Parser;
import ru.softlogic.rma.Environment;
import ru.softlogic.rma.RmaView;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.connector.model.CurrentPoint;
import ru.softlogic.rma.persistence.PersistenceException;
import ru.softlogic.rma.persistence.RmaEvent;
import ru.softlogic.rma.persistence.v2.PersistenceManager;
import ru.softlogic.rma.utils.FileUtil;
import ru.softlogic.rma.utils.FileUtilException;
import ru.softlogic.rma.utils.PathUtils;
import ru.softlogic.rma.utils.TwoCopyChecker;
import ru.softlogic.rma.version.RmaVersion;

public class RmaApp
extends SingleFrameApplication {
    private Logger log = Logger.getLogger((String)"app");

    public RmaApp() {
        this.log.setAdditivity(false);
    }

    protected void startup() {
        this.log.info((Object)"<-------------\u0412\u044b\u0437\u0432\u0430\u043d \u043c\u0435\u0442\u043e\u0434 startup-------------------->");
        ParseElementSearcher.class.getDeclaredClasses();
        System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", "true");
        Locale l = Configuration.getInstance().getData().getLocale();
        if (l != null) {
            this.log.info((Object)(LocBundle.getMessage((String)"rma.locale") + " " + l));
            Locale.setDefault(l);
        } else if (Environment.getInstance().getProperty("default_locale") != null) {
            l = new Locale(Environment.getInstance().getProperty("default_locale"));
            this.log.info((Object)(LocBundle.getMessage((String)"rma.locale") + " " + l));
            Locale.setDefault(l);
        }
        B.setLocale((Locale)l);
        RuntimeConfiguration.getInstance().setSoftwareType(SoftwareType.RMA);
        RuntimeConfiguration.getInstance().setHomePath(PathUtils.getAppHome());
        RuntimeConfiguration.getInstance().setDsPath(new File(""));
        RuntimeConfiguration.getInstance().setInitData(new HashMap());
        UIManager.put("substancelaf.addWidgets", Boolean.TRUE);
        Parser.setParams((int)3);
        AnimationConfigurationManager.getInstance().allowAnimations(AnimationFacet.FOCUS_LOOP_ANIMATION);
        AnimationConfigurationManager.getInstance().allowAnimations(AnimationFacet.GHOSTING_BUTTON_PRESS);
        AnimationConfigurationManager.getInstance().allowAnimations(AnimationFacet.GHOSTING_ICON_ROLLOVER);
        this.show((View)new RmaView(this));
        if (Configuration.getInstance().getData() != null && Configuration.getInstance().getData().getSkin() != null) {
            SubstanceLookAndFeel.setSkin((String)Configuration.getInstance().getData().getSkin());
        }
        this.log.info((Object)"<-------------\u041c\u0435\u0442\u043e\u0434 startup \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b \u0440\u0430\u0431\u043e\u0442\u0443-------------------->");
    }

    protected void configureWindow(Window root) {
    }

    public static RmaApp getApplication() {
        return (RmaApp)Application.getInstance(RmaApp.class);
    }

    public static void main(String[] args) throws InterruptedException, InvocationTargetException {
        System.getProperties().put("rma.home", PathUtils.getAppHome());
        Logger.getLogger((String)"app").info((Object)"<-----------\u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u0442\u0430\u0440\u0442 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f-------------->");
        Logger.getLogger((String)"app").info((Object)("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e rma.home=" + System.getProperties().getProperty("rma.home")));
        RmaApp.logInfo();
        CurrentPoint.getInstance().init();
        try {
            Logger.getLogger((String)"app").info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u044c \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0433\u043e \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0430");
            FileUtil.checkDir(PathUtils.getAppHome());
            Logger.getLogger((String)"app").info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0439\u0434\u0435\u043d\u0430");
        }
        catch (FileUtilException ex) {
            Logger.getLogger((String)"app").info((Object)("\u041f\u043e\u043b\u0443\u0447\u0438\u043b \u043e\u0448\u0438\u0431\u043a\u0443 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435 " + ex.getMessage()));
        }
        Logger.getLogger((String)"app").info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043a\u043e\u043f\u0438\u0439 \u0420\u041c\u0410 \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043e");
        TwoCopyChecker checker = new TwoCopyChecker();
        if (checker.tryLock()) {
            Logger.getLogger((String)"app").info((Object)"\u0417\u0430\u043f\u0443\u0449\u0435\u043d\u0430 \u043e\u0434\u043d\u0430 \u043a\u043e\u043f\u0438\u044f, \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0430\u044e \u0437\u0430\u043f\u0443\u0441\u043a");
            try {
                Logger.getLogger((String)"app").info((Object)"\u0414\u0435\u043b\u0430\u044e \u0437\u0430\u043f\u0438\u0441\u044c \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u0441\u0442\u0430\u0440\u0442\u0430 \u0432 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u0443\u044e \u0431\u0430\u0437\u0443");
                PersistenceManager.getInstance().putSystemEvent(new RmaEvent(1, "version=" + RmaVersion.getVersion() + ", build=" + RmaVersion.getBuild()));
                Logger.getLogger((String)"app").info((Object)"\u0421\u043e\u0431\u044b\u0442\u0438\u0435 \u0441\u0442\u0430\u0440\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u0432 \u0431\u0430\u0437\u0443");
            }
            catch (PersistenceException ex) {
                Logger.getLogger((String)"app").info((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u0441\u0442\u0430\u0440\u0442\u0430 \u0432 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u0443\u044e \u0431\u0430\u0437\u0443 " + ex.getMessage()));
            }
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    Logger.getLogger((String)"app").error((Object)("\u041f\u0435\u0440\u0435\u0445\u0432\u0430\u0447\u0435\u043d\u043e\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0435 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 name=" + t.getName() + ", message=" + e.getMessage()));
                    try {
                        if (e.toString().contains("cannot open system clipboard")) {
                            return;
                        }
                        if (e.toString().contains("java.lang.IllegalArgumentException: bad position")) {
                            return;
                        }
                        Logger.getLogger((String)"app").error((Object)"\u0417\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e\u0431 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u0441\u043e\u0431\u044b\u0442\u0438\u0439");
                        PersistenceManager.getInstance().putSystemEvent(new RmaEvent(2, "\u041d\u0435\u043f\u0435\u0440\u0435\u0445\u0432\u0430\u0447\u0435\u043d\u043d\u043e\u0435 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0432 \u0420\u041c\u0410 name=" + t.getName() + ", message=" + e.getMessage()));
                    }
                    catch (PersistenceException ex) {
                        Logger.getLogger((String)"app").error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0438 \u043a \u0431\u0430\u0437\u0435 message=" + ex.getMessage()));
                    }
                }
            });
            Logger.getLogger((String)"app").info((Object)"\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 LookAndFeelDecorated = true");
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            UIManager.put("OptionPane.yesButtonText", "\u0414\u0430");
            UIManager.put("OptionPane.noButtonText", "\u041d\u0435\u0442");
            UIManager.put("OptionPane.cancelButtonText", "\u041e\u0442\u043c\u0435\u043d\u0430");
            UIManager.put("OptionPane.okButtonText", "\u0413\u043e\u0442\u043e\u0432\u043e");
            UIManager.put("FileChooser.openButtonText", LocBundle.getMessage((String)"rma.config.open"));
            UIManager.put("FileChooser.cancelButtonText", LocBundle.getMessage((String)"rma.config.cansel"));
            Logger.getLogger((String)"app").info((Object)"\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e LookAndFeelDecorated \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e");
            Logger.getLogger((String)"app").info((Object)"\u0421\u0442\u0430\u0440\u0442\u0443\u044e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435, \u0432\u044b\u0437\u044b\u0432\u0430\u044e \u043c\u0435\u0442\u043e\u0434 launch");
            Application.launch(RmaApp.class, (String[])args);
            Logger.getLogger((String)"app").info((Object)"\u041c\u0435\u0442\u043e\u0434 lauch \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b \u0440\u0430\u0431\u043e\u0442\u0443");
        } else {
            Logger.getLogger((String)"app").info((Object)"\u0417\u0430\u043f\u0443\u0449\u0435\u043d\u0430 \u0432\u0442\u043e\u0440\u0430\u044f \u043a\u043e\u043f\u0438\u044f, \u0434\u0430\u043b\u044c\u043d\u0435\u0439\u0448\u0438\u0439 \u0437\u0430\u043f\u0443\u0441\u043a \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d!");
            Logger.getLogger((String)"app").info((Object)"\u0412\u044b\u0432\u043e\u0436\u0443 \u0434\u0438\u0430\u043b\u043e\u0433 \u043e \u0437\u0430\u043f\u0443\u0441\u043a\u0435 2\u0439 \u043a\u043e\u043f\u0438\u0438");
            JOptionPane.showMessageDialog(null, LocBundle.getMessage((String)"rma.dblcopy"), LocBundle.getMessage((String)"rma.errorrun"), 0);
            Logger.getLogger((String)"app").info((Object)"\u0412\u044b\u0445\u043e\u0436\u0443 \u0438\u0437 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b \u0437\u0430\u043f\u0443\u0441\u043a\u0430, \u0437\u0430\u043f\u0443\u0441\u043a \u0420\u041c\u0410 \u043d\u0435 \u0431\u044b\u043b \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0451\u043d.");
            System.exit(0);
        }
    }

    private static void logInfo() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss,SSS 'GMT'");
        Logger log = Logger.getLogger((String)"app");
        log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f: " + sdf.format(new Date())));
        log.info((Object)("\u0412\u0435\u0440\u0441\u0438\u044f \u0420\u041c\u0410 " + RmaVersion.getVersion()));
        log.info((Object)("\u0421\u0431\u043e\u0440\u043a\u0430 \u043e\u0442 " + RmaVersion.getBuild()));
        log.info((Object)("Java version: " + System.getProperty("java.version")));
        log.info((Object)("Operating system architecture: " + System.getProperty("os.arch")));
        log.info((Object)("Operating system name: " + System.getProperty("os.name") + " " + System.getProperty("os.version")));
    }
}

