/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXHyperlink;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.persistence.v2.PersistenceManager;
import ru.softlogic.rma.utils.PathUtils;
import ru.softlogic.rma.version.RmaVersion;

public class RmaAboutBox
extends JDialog {
    private JXHyperlink appHomepageLabel;
    private JLabel appTitleLabel;
    private JLabel build;
    private JLabel buildLabel;
    private JButton closeButton;
    private JLabel dbLabel;
    private JLabel dbVersion;
    private JLabel imageLabel;
    private JLabel javaLabel;
    private JLabel javaVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmaAboutBox(Frame parent) {
        super(parent);
        this.initComponents();
        try {
            this.dbVersion.setText(PersistenceManager.getInstance().getVersion());
            this.imageLabel.setIcon(new ImageIcon(ImageIO.read(new File(PathUtils.getAppHome() + File.separator + "trademark" + File.separator + "about.png"))));
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileInputStream fis = null;
        try {
            String site;
            Properties prop = new Properties();
            fis = new FileInputStream(PathUtils.getAppHome() + File.separator + "trademark" + File.separator + "info.properties");
            prop.load(new InputStreamReader((InputStream)fis, "utf-8"));
            String title = prop.getProperty("about.title");
            if (title != null) {
                this.setTitle(title);
            }
            if ((title = prop.getProperty("about.info")) != null) {
                this.appTitleLabel.setText(title);
            }
            if ((site = prop.getProperty("about.site")) != null) {
                this.appHomepageLabel.setText(site);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmaAboutBox.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().setDefaultButton(this.closeButton);
    }

    @Action
    public void closeAboutBox() {
        this.dispose();
    }

    private void initComponents() {
        this.closeButton = new JButton();
        this.appTitleLabel = new JLabel();
        JLabel versionLabel = new JLabel();
        JLabel appVersionLabel = new JLabel();
        JLabel vendorLabel = new JLabel();
        JLabel appVendorLabel = new JLabel();
        JLabel homepageLabel = new JLabel();
        JLabel appDescLabel = new JLabel();
        this.imageLabel = new JLabel();
        this.appHomepageLabel = new JXHyperlink();
        this.buildLabel = new JLabel();
        this.build = new JLabel();
        this.javaLabel = new JLabel();
        this.javaVersion = new JLabel();
        this.dbLabel = new JLabel();
        this.dbVersion = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(RmaAboutBox.class);
        this.setTitle(resourceMap.getString("RmaAboutBox.title", new Object[0]));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setName("aboutBox");
        ApplicationActionMap actionMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getActionMap(RmaAboutBox.class, (Object)this);
        this.closeButton.setAction(actionMap.get("closeAboutBox"));
        this.closeButton.setText(resourceMap.getString("action.close", new Object[0]));
        this.appTitleLabel.setFont(new Font("Tahoma", 1, 14));
        this.appTitleLabel.setText(resourceMap.getString("Application.title", new Object[0]));
        versionLabel.setFont(versionLabel.getFont().deriveFont(versionLabel.getFont().getStyle() | 1));
        versionLabel.setText(resourceMap.getString("RmaAboutBox.versionLabel.text", new Object[0]));
        appVersionLabel.setText(RmaVersion.getVersion());
        vendorLabel.setFont(new Font("Tahoma", 1, 11));
        vendorLabel.setText(resourceMap.getString("RmaAboutBox.vendorLabel.text", new Object[0]));
        appVendorLabel.setText(resourceMap.getString("Application.vendor", new Object[0]));
        homepageLabel.setFont(new Font("Tahoma", 1, 11));
        homepageLabel.setText(resourceMap.getString("RmaAboutBox.homepageLabel.text", new Object[0]));
        appDescLabel.setText(resourceMap.getString("RmaAboutBox.appDescLabel.text", new Object[0]));
        appDescLabel.setVerticalAlignment(1);
        this.imageLabel.setIcon(new ImageIcon(this.getClass().getResource("/ru/softlogic/rma/resources/logo/about.png")));
        this.appHomepageLabel.setAction(actionMap.get("openSite"));
        this.appHomepageLabel.setText(resourceMap.getString("RmaAboutBox.appHomepageLabel.text", new Object[0]));
        this.buildLabel.setFont(new Font("Tahoma", 1, 11));
        this.buildLabel.setText(resourceMap.getString("RmaAboutBox.buildLabel.text", new Object[0]));
        this.build.setText(RmaVersion.getBuild());
        this.javaLabel.setFont(new Font("Tahoma", 1, 11));
        this.javaLabel.setText(resourceMap.getString("RmaAboutBox.javaLabel.text", new Object[0]));
        this.javaVersion.setText(System.getProperty("java.version"));
        this.dbLabel.setFont(new Font("Tahoma", 1, 11));
        this.dbLabel.setText(resourceMap.getString("RmaAboutBox.dbLabel.text", new Object[0]));
        this.dbVersion.setText("jLabel6");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.imageLabel, -2, 120, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(appDescLabel, -1, 386, Short.MAX_VALUE).addComponent(this.appTitleLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.dbLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.javaLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(homepageLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.buildLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(vendorLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(versionLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.build, -1, 242, Short.MAX_VALUE).addComponent(this.javaVersion, -1, 242, Short.MAX_VALUE).addComponent(appVendorLabel, -1, 242, Short.MAX_VALUE).addComponent((Component)this.appHomepageLabel, -1, 242, Short.MAX_VALUE).addComponent(appVersionLabel, -1, 242, Short.MAX_VALUE).addComponent(this.dbVersion, -1, 242, Short.MAX_VALUE))))).addComponent(this.closeButton, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.appTitleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(appDescLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(versionLabel).addComponent(appVersionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buildLabel).addComponent(this.build)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(vendorLabel).addComponent(appVendorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(homepageLabel).addComponent((Component)this.appHomepageLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaLabel).addComponent(this.javaVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dbLabel).addComponent(this.dbVersion))).addComponent(this.imageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 23, Short.MAX_VALUE).addComponent(this.closeButton).addContainerGap()));
        this.closeButton.getAccessibleContext().setAccessibleName("");
        this.pack();
    }

    @Action
    public void openSite() {
        try {
            Desktop.getDesktop().browse(new URI(this.appHomepageLabel.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

