/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.rma.RmaAppContext;
import ru.softlogic.rma.RmaPaymentJob;
import ru.softlogic.rma.RmaView;
import ru.softlogic.rma.model.add.BankRecord;
import ru.softlogic.rma.model.add.PD4Fields;
import ru.softlogic.rma.persistence.RmaAttribute;
import ru.softlogic.rma.providers.universal.form.SetField;
import ru.softlogic.rma.providers.universal.general.ControlData;
import ru.softlogic.rma.providers.universal.general.PD4Dialog;
import ru.softlogic.rma.utils.BikAccountVerifier;
import ru.softlogic.rma.utils.GuiUtils;
import ru.softlogic.rma.utils.IM7FormUtils;
import ru.softlogic.rma.utils.PathUtils;

public class PrintCopyPayment {
    private PD4Dialog pd4Dialog;
    private RmaAppContext context;
    private Logger log = Logger.getLogger((String)"app");
    private Map<String, BankRecord> bankRecords;
    private RmaPaymentJob job;

    public PrintCopyPayment(RmaAppContext context, Map<String, BankRecord> bankRecords, RmaPaymentJob job) {
        this.log.setAdditivity(false);
        this.context = context;
        this.bankRecords = bankRecords;
        this.job = job;
    }

    public void process() {
        Form pd4Form = IM7FormUtils.tryToLoadForm(new File(PathUtils.getAppHome() + File.separator + "resources" + File.separator + "addforms" + File.separator + "pd4.xml"), this.log);
        if (pd4Form == null || IM7FormUtils.getFieldsFromForm(pd4Form) == null || IM7FormUtils.getFieldsFromForm(pd4Form).isEmpty()) {
            this.log.info((Object)LocBundle.getMessageEx((String)"rma.payment.nopd4found"));
        }
        HashMap<String, IdentityField> pd4Fields = new HashMap<String, IdentityField>();
        for (IdentityField ff : IM7FormUtils.getFieldsFromForm(pd4Form)) {
            pd4Fields.put(ff.getId(), ff);
        }
        LinkedHashMap<String, Object> form = new LinkedHashMap<String, Object>();
        for (String key : this.job.getRecord().getAttributes().keySet()) {
            RmaAttribute attr = this.job.getRecord().getAttributes().get(key);
            InputElement ie = new InputElement(key, attr.getKeyTitle(), attr.getValue(), attr.getValueTitle(), 0);
            form.put(key, ie);
        }
        Map<Field, Object> map = PD4Fields.getPD4Values(this.job.getMenuItem(), pd4Fields, form);
        if (this.pd4Dialog == null) {
            this.pd4Dialog = new PD4Dialog((Frame)this.context.getMainFrame(), true);
            this.pd4Dialog.getCancelButton().addActionListener(new PD4CancelActionListener());
            this.pd4Dialog.getPrintButton().addActionListener(new PD4PrintActionListener());
            this.pd4Dialog.setLocationRelativeTo(this.context.getMainFrame());
            this.pd4Dialog.setBankRecords(this.bankRecords);
        }
        this.pd4Dialog.showFields(IM7FormUtils.getFieldsFromForm(pd4Form), map);
        this.pd4Dialog.getPrintButton().setEnabled(true);
        this.pd4Dialog.setVisible(true);
    }

    private void checkFields(Map<String, String> form, Map<String, String> views, Map<String, String> titles, boolean userReplaces, List<ControlData> data) throws Exception {
        SelectorItem tsi;
        SelectorField textSelector;
        TextField inputField;
        Field ff;
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.univers.workflds") + " "));
        HashMap<String, String> tvs = new HashMap<String, String>();
        for (ControlData cd : data) {
            ff = cd.getField();
            if (ff instanceof TextField) {
                inputField = (TextField)ff;
                tvs.put(inputField.getId(), (String)cd.getData());
                continue;
            }
            if (!(ff instanceof SelectorField)) continue;
            textSelector = (SelectorField)ff;
            tsi = (SelectorItem)cd.getData();
            tvs.put(textSelector.getId(), tsi == null ? "" : tsi.getValue());
        }
        for (ControlData cd : data) {
            this.log.info((Object)("\t" + cd));
            ff = cd.getField();
            if (ff instanceof TextField) {
                inputField = (TextField)ff;
                String number = (String)cd.getData();
                boolean valid = false;
                if (inputField.getValidator() != null) {
                    valid = inputField.getValidator().validate(number);
                }
                if (!valid) {
                    GuiUtils.requestFocus(cd.getComponent());
                    if (inputField.getExampleValue() != null && !inputField.getExampleValue().trim().isEmpty()) {
                        throw new Exception(MessageFormat.format(LocBundle.getMessageEx((String)"rma.prov.wrongnumb2"), inputField.getTitle(), inputField.getExampleValue()));
                    }
                    throw new Exception(MessageFormat.format(LocBundle.getMessageEx((String)"rma.prov.wrongnumb"), inputField.getTitle()));
                }
                form.put(inputField.getId(), number);
                if (views != null) {
                    views.put(inputField.getId(), number);
                }
                if (titles == null) continue;
                titles.put(inputField.getId(), inputField.getTitle());
                continue;
            }
            if (ff instanceof SelectorField) {
                textSelector = (SelectorField)ff;
                if (cd.getData() == null) {
                    GuiUtils.requestFocus(cd.getComponent());
                    throw new Exception(MessageFormat.format(LocBundle.getMessageEx((String)"rma.prov.wrongnumb"), textSelector.getTitle()));
                }
                tsi = (SelectorItem)cd.getData();
                form.put(textSelector.getId(), tsi.getValue());
                if (views != null) {
                    views.put(textSelector.getId(), tsi.getTitle());
                }
                if (titles == null) continue;
                titles.put(textSelector.getId(), textSelector.getTitle());
                continue;
            }
            if (!(ff instanceof SetField)) continue;
            SetField sf = (SetField)ff;
            String val = sf.getValue() == null ? "" : sf.getValue();
            for (String key : tvs.keySet()) {
                val = val.replace("${" + key + "}", (CharSequence)tvs.get(key));
            }
            if (("id1".equals(sf.getId()) || "id2".equals(sf.getId())) && val.length() > 40) {
                val = val.substring(0, 40);
            }
            form.put(sf.getId(), val);
            if (views != null) {
                views.put(sf.getId(), val);
            }
            if (titles == null) continue;
            titles.put(sf.getId(), sf.getTitle());
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.univers.resform"));
        for (String key : form.keySet()) {
            this.log.info((Object)("\t" + key + "->" + form.get(key) + (views != null ? ",view=" + views.get(key) : "") + (titles != null ? ",title=" + titles.get(key) : "")));
        }
    }

    private void checkBikAccount(List<ControlData> data) throws Exception {
        block6: {
            String bik = null;
            String account = null;
            JComponent accountComponent = null;
            for (ControlData cd : data) {
                Field ff = cd.getField();
                if (!(ff instanceof TextField)) continue;
                TextField inputField = (TextField)ff;
                if ("recipient_acc".equals(inputField.getId())) {
                    account = (String)cd.getData();
                    accountComponent = cd.getComponent();
                }
                if (!"corr_bik".equals(inputField.getId())) continue;
                bik = (String)cd.getData();
            }
            if (bik != null && account != null) {
                try {
                    BankRecord rec = this.bankRecords.get(bik);
                    if (!BikAccountVerifier.verify(bik, account, rec != null && (rec.getKs() == null || rec.getKs().trim().isEmpty()) ? 1 : 2)) {
                        throw new Exception(LocBundle.getMessageEx((String)"provider.pd4.bikaccountnotvalid"));
                    }
                    break block6;
                }
                catch (Exception e) {
                    GuiUtils.requestFocus(accountComponent);
                    throw e;
                }
            }
            this.log.error((Object)LocBundle.getMessageLog((String)"provider.pd4.bikorrsnotfound"));
        }
    }

    public PD4Dialog getPd4Dialog() {
        return this.pd4Dialog;
    }

    public RmaPaymentJob getJob() {
        return this.job;
    }

    private class PD4CancelActionListener
    implements ActionListener {
        private PD4CancelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PrintCopyPayment.this.pd4Dialog.setVisible(false);
        }
    }

    private class PD4PrintActionListener
    implements ActionListener {
        private PD4PrintActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PrintCopyPayment.this.pd4Dialog.getPrintButton().setEnabled(false);
            LinkedHashMap form = new LinkedHashMap();
            LinkedHashMap views = new LinkedHashMap();
            LinkedHashMap titles = new LinkedHashMap();
            try {
                PrintCopyPayment.this.checkFields(form, views, titles, true, PrintCopyPayment.this.pd4Dialog.getData());
                PrintCopyPayment.this.checkBikAccount(PrintCopyPayment.this.pd4Dialog.getData());
                for (String key : form.keySet()) {
                    RmaAttribute atr = new RmaAttribute();
                    atr.setKey(key);
                    atr.setKeyTitle((String)titles.get(key));
                    atr.setValue((String)form.get(key));
                    atr.setValueTitle((String)views.get(key));
                    PrintCopyPayment.this.job.getRecord().getAttributes().put(key, atr);
                }
                if (!((RmaView)PrintCopyPayment.this.context).toPrintPD4(PrintCopyPayment.this.job)) {
                    PrintCopyPayment.this.pd4Dialog.getPrintButton().setEnabled(true);
                } else {
                    PrintCopyPayment.this.pd4Dialog.setVisible(false);
                }
            }
            catch (Exception ex) {
                PrintCopyPayment.this.pd4Dialog.getPrintButton().setEnabled(true);
                PrintCopyPayment.this.log.info((Object)(LocBundle.getMessageLog((String)"rma.adv.dopayerr") + " " + ex.getMessage()));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(PrintCopyPayment.this.pd4Dialog, ex.getMessage(), LocBundle.getMessage((String)"rma.adv.dopayerr"), 0);
                    }
                });
            }
        }
    }
}

