/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.log4j.Logger;
import ru.softlogic.rma.utils.Base64Utils;
import ru.softlogic.rma.utils.PathUtils;

public class Environment {
    private static Environment _instance = null;
    private Properties props = null;
    public static final String DEFAULT_MOBILE_MASK = "8(***)***-****";
    public static final String MOBILE_MASK = "mobile_mask";
    public static final String DEFAULT_MOBILE_LEN = "10";
    public static final String MOBILE_LEN = "mobile_len";
    public static final String DEFAULT_MOBILE_REGEX = "^\\d{10}$";
    public static final String MOBILE_REGEX = "mobile_regex";
    public static final String EMAILS_TO_SEND = "emails_to_send";
    public static final String DEFAULT_EMAIL = "info@soft-logic.ru";
    public static final String EMAIL_FROM_SEND = "email_from_address";
    public static final String EMAIL_FROM_SEND_PASS = "email_from_pass";
    public static final String EMAIL_HOST = "email_host";
    public static final String DEFAULT_LOCALE = "default_locale";
    public static final String TYPE_POINT_CASHSOURCE = "type_point";
    public static final String NUMBER_PROVIDER_VPOS = "provider_id";
    public static final String CAPACITY_AUTO_REDIRECT = "capacity_auto_redirect";
    public static final String SUM1 = "sum1";
    public static final String SUM2 = "sum2";
    public static final String MAIN_SHIFT_START = "main_shift_start";
    public static final String MAIN_SHIFT_END = "main_shift_end";
    public static final String OUTCASHBOX_SHIFT_START = "outcashbox_shift_start";
    public static final String OUTCASHBOX_SHIFT_END = "outcashbox_shift_end";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Environment() {
        Logger log;
        try {
            this.props = Environment.readUtf8Properties(new FileInputStream(new File(PathUtils.getAppHome() + File.separator + "resources" + File.separator + "enviroment.cfg")));
        }
        catch (Exception ex) {
            log = Logger.getLogger((String)"app");
            log.setAdditivity(false);
            log.info((Object)ex);
        }
        finally {
            if (this.props == null) {
                this.props = new Properties();
            }
            if (this.props.getProperty(MOBILE_MASK) == null) {
                this.props.setProperty(MOBILE_MASK, DEFAULT_MOBILE_MASK);
            }
            if (this.props.getProperty(MOBILE_LEN) == null) {
                this.props.setProperty(MOBILE_LEN, DEFAULT_MOBILE_LEN);
            }
            if (this.props.getProperty(MOBILE_REGEX) == null) {
                this.props.setProperty(MOBILE_REGEX, DEFAULT_MOBILE_REGEX);
            }
            if (this.props.getProperty(EMAILS_TO_SEND) == null) {
                this.props.put(EMAILS_TO_SEND, DEFAULT_EMAIL);
            }
            if (this.props.getProperty(EMAIL_FROM_SEND) == null) {
                this.props.put(EMAIL_FROM_SEND, "no email");
            }
            if (this.props.getProperty(EMAIL_FROM_SEND_PASS) != null) {
                try {
                    String[] split = this.props.getProperty(EMAIL_FROM_SEND_PASS).split(",");
                    if (split.length != 2) {
                        this.props.remove(EMAIL_FROM_SEND_PASS);
                    } else {
                        byte[] pass = Base64Utils.decode(split[0].getBytes());
                        byte[] key = Base64Utils.decode(split[1].getBytes());
                        Cipher cip = Cipher.getInstance("DES/ECB/PKCS5Padding");
                        cip.init(2, SecretKeyFactory.getInstance("DES").generateSecret(new DESKeySpec(key)));
                        String passw = new String(cip.doFinal(pass));
                        this.props.put(EMAIL_FROM_SEND_PASS, passw);
                    }
                }
                catch (Exception ex) {
                    log = Logger.getLogger((String)"app");
                    log.setAdditivity(false);
                    log.info((Object)ex);
                }
            }
        }
    }

    private static Properties readUtf8Properties(InputStream is) throws IOException {
        Properties properties = new Properties();
        properties.load(is);
        for (Object key : properties.keySet()) {
            String value = properties.getProperty(key.toString());
            String goodValue = new String(value.getBytes("iso8859-1"), "utf-8");
            properties.setProperty(key.toString(), goodValue);
        }
        is.close();
        return properties;
    }

    public static synchronized Environment getInstance() {
        if (_instance == null) {
            _instance = new Environment();
        }
        return _instance;
    }

    public String getProperty(String prop) {
        return this.props.getProperty(prop);
    }

    public Integer getIntProperty(String property, Integer defaultValue) {
        try {
            return Integer.parseInt(this.props.getProperty(property));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getStringProperty(String property, String defaultValue) {
        try {
            return this.props.getProperty(property);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

