/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import ru.softlogic.rma.BarcodeDialogListener;
import ru.softlogic.rma.RmaApp;
import ru.softlogic.rma.connector.model.MenuItem;

public class BarcodeSearchDialog
extends JDialog {
    private BarcodeDialogListener listener;
    private String lastBarcode;
    private JTextField barcodeField;
    private JLabel barcodeLabel;
    private JScrollPane jScrollPane1;
    private JButton searchButton;
    private JLabel servicesLabel;
    private JList servicesList;

    public BarcodeSearchDialog(Frame parent, BarcodeDialogListener listener) {
        super(parent, true);
        this.initComponents();
        this.listener = listener;
    }

    public void setListener(BarcodeDialogListener listener) {
        this.listener = listener;
    }

    public JList getServicesList() {
        return this.servicesList;
    }

    private void initComponents() {
        this.barcodeField = new JTextField();
        this.barcodeLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.servicesList = new JList();
        this.servicesLabel = new JLabel();
        this.searchButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setName("Form");
        this.barcodeField.setName("barcodeField");
        this.barcodeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BarcodeSearchDialog.this.BarcodeActionPerformed(evt);
            }
        });
        ResourceMap resourceMap = ((RmaApp)Application.getInstance(RmaApp.class)).getContext().getResourceMap(BarcodeSearchDialog.class);
        this.barcodeLabel.setText(resourceMap.getString("barcodeLabel.text", new Object[0]));
        this.barcodeLabel.setName("barcodeLabel");
        this.jScrollPane1.setName("jScrollPane1");
        this.servicesList.setFocusable(false);
        this.servicesList.setName("servicesList");
        this.servicesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BarcodeSearchDialog.this.ServiceListDoubleClick(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.servicesList);
        this.servicesLabel.setText(resourceMap.getString("servicesLabel.text", new Object[0]));
        this.servicesLabel.setName("servicesLabel");
        this.searchButton.setIcon(resourceMap.getIcon("searchButton.icon"));
        this.searchButton.setText(resourceMap.getString("searchButton.text", new Object[0]));
        this.searchButton.setFocusable(false);
        this.searchButton.setName("searchButton");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BarcodeSearchDialog.this.SearchButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 377, Short.MAX_VALUE).addComponent(this.barcodeLabel, GroupLayout.Alignment.LEADING).addComponent(this.servicesLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.barcodeField, -2, 340, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton, -2, 31, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.barcodeLabel).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.searchButton, -1, -1, Short.MAX_VALUE).addComponent(this.barcodeField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.servicesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 212, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void BarcodeActionPerformed(ActionEvent evt) {
        this.searchButton.doClick();
    }

    private void ServiceListDoubleClick(MouseEvent evt) {
        if (evt.getClickCount() > 2 && this.servicesList.getSelectedValue() != null) {
            this.listener.onMenuItem(((ListMenuItem)this.servicesList.getSelectedValue()).getMenuItem(), this.lastBarcode);
        }
    }

    private void SearchButtonActionPerformed(ActionEvent evt) {
        this.lastBarcode = this.barcodeField.getText().trim();
        this.barcodeField.setText("");
        if (this.listener != null) {
            this.listener.onBarcode(this.lastBarcode);
        }
    }

    public void setMenuItems(MenuItem[] menuItems) {
        if (menuItems == null) {
            menuItems = new MenuItem[]{};
        }
        if (menuItems.length == 1) {
            if (this.listener != null) {
                this.listener.onMenuItem(menuItems[0], this.lastBarcode);
            }
            return;
        }
        ListMenuItem[] list = new ListMenuItem[menuItems.length];
        for (int i = 0; i < list.length; ++i) {
            list[i] = new ListMenuItem(menuItems[i]);
        }
        this.servicesList.setListData(list);
    }

    private class ListMenuItem {
        private MenuItem menuItem;

        public ListMenuItem(MenuItem menuItem) {
            this.menuItem = menuItem;
        }

        public MenuItem getMenuItem() {
            return this.menuItem;
        }

        public String toString() {
            return "" + this.menuItem.getService().getFullName();
        }
    }
}

