/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io.serial;

import java.io.IOException;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.PortType;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.StopBits;

public class SerialPort
extends BidirectionPort {
    private SerialParams params;

    public SerialPort(String name) {
        super(name);
        this.params = new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None);
    }

    public SerialPort(String name, SerialParams params) {
        super(name);
        if (params == null) {
            throw new IllegalArgumentException("Need port params");
        }
        this.params = params;
    }

    @Override
    public PortType getType() {
        return PortType.SerialPort;
    }

    @Override
    public void open() throws IOException {
        this.openNative(this.name);
        this.setParams(this.params);
        this.setFlow(Flow.None);
    }

    public void setParams(SerialParams params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("Need SerialParams");
        }
        this.params = params;
        this.setParamsNative(params.getSpeed(), params.getDataBits().getCode(), params.getStopBits().getCode(), params.getParity().getCode());
    }

    public void setFlow(Flow flow) throws IOException {
        this.setFlowNative(flow.getCode());
    }

    public void putParams(SerialParams params) {
        if (params == null) {
            throw new IllegalArgumentException("Need SerialParams");
        }
        this.params = params;
    }

    public SerialParams getParams() {
        return this.params;
    }

    public void setRTS(boolean state) throws IOException {
        this.setRtsNative(state);
    }

    public void setDTR(boolean state) throws IOException {
        this.setDtrNative(state);
    }

    public boolean isCTS() throws IOException {
        return this.isCtsNative();
    }

    public boolean isRNG() throws IOException {
        return this.isRngNative();
    }

    public boolean isDSR() throws IOException {
        return this.isDsrNative();
    }

    private native void openNative(String var1) throws IOException;

    private native void setFlowNative(int var1) throws IOException;

    private native void setParamsNative(int var1, int var2, int var3, int var4) throws IOException;

    private native void setRtsNative(boolean var1) throws IOException;

    private native void setDtrNative(boolean var1) throws IOException;

    private native boolean isCtsNative() throws IOException;

    private native boolean isRngNative() throws IOException;

    private native boolean isDsrNative() throws IOException;

    public String toString() {
        return "SerialPort[name=" + this.name + ",params=" + this.params + ']';
    }
}

