/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io.serial;

import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.StopBits;

public class SerialParams {
    private int speed;
    private DataBits dataBits;
    private StopBits stopBits;
    private Parity parity;

    public SerialParams(int speed, DataBits dataBits, StopBits stopBits, Parity parity) {
        if (speed <= 0) {
            throw new IllegalArgumentException("Wrong Speed");
        }
        if (dataBits == null) {
            throw new IllegalArgumentException("Need DataBits");
        }
        if (stopBits == null) {
            throw new IllegalArgumentException("Need StopBits");
        }
        if (parity == null) {
            throw new IllegalArgumentException("Need Parity");
        }
        this.speed = speed;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.parity = parity;
    }

    public DataBits getDataBits() {
        return this.dataBits;
    }

    public Parity getParity() {
        return this.parity;
    }

    public int getSpeed() {
        return this.speed;
    }

    public StopBits getStopBits() {
        return this.stopBits;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[speed=" + this.speed + ",databits=" + this.dataBits.getName() + ",stopbits=" + this.stopBits.getName() + ",parity=" + (Object)((Object)this.parity) + "]";
    }
}

