/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.io.BasePort;
import ru.softlogic.io.Port;
import ru.softlogic.io.PortId;
import ru.softlogic.io.PortType;
import ru.softlogic.io.parallel.ParallelPort;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.usb.UsbPort;
import ru.softlogic.system.util.OsDetector;

public class PortScanner {
    public static PortId[] scan() {
        String[] usb;
        String[] lpt;
        LinkedList<PortId> ports = new LinkedList<PortId>();
        String[] com = PortScanner.scanSerialNative();
        if (com != null && com.length > 0) {
            for (String port : com) {
                ports.add(new PortId(port, PortType.SerialPort));
            }
        }
        if ((lpt = PortScanner.scanParallelNative()) != null && lpt.length > 0) {
            for (String port : lpt) {
                ports.add(new PortId(port, PortType.ParallelPort));
            }
        }
        if ((usb = PortScanner.scanUsbNative()) != null && usb.length > 0) {
            for (String port : usb) {
                ports.add(new PortId(port, PortType.UsbPort));
            }
        }
        return ports.toArray(new PortId[ports.size()]);
    }

    public static String[] scanSerial() {
        return PortScanner.scanSerialNative();
    }

    public static String[] scanParallel() {
        return PortScanner.scanParallelNative();
    }

    public static String[] scanUsb() {
        return PortScanner.scanUsbNative();
    }

    public static PortType getType(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (PortId portId : PortScanner.scan()) {
            if (!portId.getName().equals(name)) continue;
            return portId.getType();
        }
        return null;
    }

    public static PortType suggestType(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        if (name.matches("^COM[1-9]+[0-9]?$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^/dev/ttyS[0-9]{1,2}$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^/dev/ttyD[0-9]{1,2}$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^/dev/ttyUSB[0-9]{1,2}$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^LPT[1-9]+[0-9]?$")) {
            return PortType.ParallelPort;
        }
        if (name.matches("^/dev/lp[0-9]{1,2}$")) {
            return PortType.ParallelPort;
        }
        if (name.matches("^/dev/usb/lp[0-9]{1,2}$")) {
            return PortType.UsbPort;
        }
        return null;
    }

    public static Port createPort(String name) {
        PortType type = PortScanner.getType(name);
        if (type == PortType.ParallelPort) {
            return new ParallelPort(name);
        }
        if (type == PortType.SerialPort) {
            return new SerialPort(name);
        }
        if (type == PortType.UsbPort) {
            return new UsbPort(name);
        }
        return null;
    }

    private static native String[] scanSerialNative();

    private static native String[] scanParallelNative();

    private static native String[] scanUsbNative();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Logger log = Logger.getLogger((String)"app");
        log.setAdditivity(false);
        String libName = null;
        switch (OsDetector.current()) {
            case 1: {
                libName = "libcommlogic.so";
                break;
            }
            case 2: {
                String osArch = System.getProperty("os.arch");
                String realArch = osArch.endsWith("64") ? "64" : "32";
                libName = realArch.equals("64") ? "commlogic64.dll" : "commlogic.dll";
            }
        }
        if (libName == null) {
            log.error((Object)LocBundle.getMessageLog((String)"io.undefOS"));
        }
        File f = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            int bt;
            f = File.createTempFile(libName, ".tmp");
            os = new FileOutputStream(f);
            is = BasePort.class.getResourceAsStream(libName);
            while ((bt = is.read()) != -1) {
                os.write(bt);
            }
        }
        catch (IOException ex) {
            log.error((Object)ex, (Throwable)ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ex) {}
            try {
                os.close();
            }
            catch (Exception ex) {}
        }
        if (f != null) {
            log.info((Object)(LocBundle.getMessageLog((String)"io.loadinglib") + " " + f.getAbsolutePath()));
            System.load(f.getAbsolutePath());
        }
        try {
            if (f != null) {
                File[] listFiles;
                File dir = f.getParentFile();
                for (File file : listFiles = dir.listFiles()) {
                    if (!file.getName().contains("commlogic") || file.getName().equals(f.getName())) continue;
                    try {
                        file.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
        f.deleteOnExit();
    }
}

