/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.io.Port;
import ru.softlogic.system.util.OsDetector;

public abstract class BasePort
implements Port {
    protected String name;
    protected int fd;
    protected int timeout;

    public BasePort(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("'name' is required");
        }
        this.name = name;
        this.timeout = 100;
        this.fd = -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        this.closeNative();
        this.fd = -1;
    }

    @Override
    public void reopen() throws IOException {
        if (this.isOpen()) {
            this.close();
        }
        this.open();
    }

    @Override
    public boolean isOpen() {
        return this.isOpenNative();
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public int avaliable() throws IOException {
        return this.avaliableNative();
    }

    @Override
    public byte[] tryRead() throws IOException {
        return this.tryReadNative();
    }

    @Override
    public byte[] tryRead(int maxSize) throws IOException {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be positive");
        }
        return this.tryReadNative(maxSize);
    }

    @Override
    public byte[] read() throws IOException {
        return this.readNative();
    }

    @Override
    public byte[] read(int maxSize) throws IOException {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be positive");
        }
        return this.readNative(maxSize);
    }

    @Override
    public int readByte() throws IOException {
        byte[] res = this.read(1);
        return res[0] & 0xFF;
    }

    @Override
    public void write(byte[] data) throws IOException {
        if (data.length == 0) {
            return;
        }
        this.writeNative(data);
    }

    @Override
    public void write(byte data) throws IOException {
        this.writeNative(data);
    }

    private native boolean isOpenNative();

    private native void closeNative();

    private native int avaliableNative() throws IOException;

    private native byte[] tryReadNative() throws IOException;

    private native byte[] tryReadNative(int var1) throws IOException;

    private native byte[] readNative() throws IOException;

    private native byte[] readNative(int var1) throws IOException;

    private native void writeNative(byte[] var1) throws IOException;

    private native void writeNative(byte var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Logger log = Logger.getLogger((String)"app");
        log.setAdditivity(false);
        String libName = null;
        switch (OsDetector.current()) {
            case 1: {
                libName = "libcommlogic.so";
                break;
            }
            case 2: {
                String osArch = System.getProperty("os.arch");
                String realArch = osArch.endsWith("64") ? "64" : "32";
                libName = realArch.equals("64") ? "commlogic64.dll" : "commlogic.dll";
            }
        }
        if (libName == null) {
            log.error((Object)LocBundle.getMessage((String)"io.undefOS"));
        }
        File f = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            int bt;
            f = File.createTempFile(libName, ".tmp");
            os = new FileOutputStream(f);
            is = BasePort.class.getResourceAsStream(libName);
            while ((bt = is.read()) != -1) {
                os.write(bt);
            }
            os.flush();
        }
        catch (IOException ex) {
            log.error((Object)ex, (Throwable)ex);
            log.error((Object)(LocBundle.getMessageLog((String)"io.nativelder") + " " + libName), (Throwable)ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ex) {}
            try {
                os.close();
            }
            catch (Exception ex) {}
        }
        if (f != null) {
            log.info((Object)(LocBundle.getMessageLog((String)"io.loadinglib") + " " + f.getAbsolutePath()));
            System.load(f.getAbsolutePath());
        }
        try {
            if (f != null) {
                File[] listFiles;
                File dir = f.getParentFile();
                for (File file : listFiles = dir.listFiles()) {
                    if (!file.getName().contains("commlogic") || file.getName().equals(f.getName())) continue;
                    try {
                        file.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
        f.deleteOnExit();
    }
}

