/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.CRC32;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import ru.softlogic.generator.BadEncodingException;
import ru.softlogic.generator.BadXmlException;

public class FileListGenerator {
    public static void main(String[] args) {
        FileListGenerator.updateVersion();
        try {
            PrintWriter pw = new PrintWriter("list.xml");
            File dir = new File(".");
            StringBuilder res = new StringBuilder("<root>\n");
            FileListGenerator.list(dir, "", res);
            res.append("</root>");
            pw.write(res.toString());
            pw.close();
            File list = new File(dir, "list.xml");
            long listCrc = FileListGenerator.calculateChecksum(list);
            FileListGenerator.setListParams(listCrc, list.length(), list.lastModified());
            System.exit(0);
        }
        catch (BadXmlException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            System.exit(2);
        }
        catch (BadEncodingException ex) {
            ex.printStackTrace();
            System.exit(3);
        }
    }

    private static void list(File dir, String path, StringBuilder res) throws BadXmlException, BadEncodingException {
        File[] files = dir.listFiles();
        TreeSet<File> sortFiles = new TreeSet<File>();
        for (File file : files) {
            sortFiles.add(file);
        }
        FileListGenerator.checkXML(sortFiles);
        for (File file : sortFiles) {
            if (file.isDirectory()) {
                FileListGenerator.list(file, path + file.getName() + "/", res);
                continue;
            }
            if (file.getName().equals("list.xml") || file.getName().equals("list.crc") || file.getName().equals("FileListGenerator.jar") || file.getName().equals("update.sh")) continue;
            if (!file.getAbsolutePath().matches("^[0-9a-zA-Z\\./_-]+$")) {
                throw new BadEncodingException(file.getAbsolutePath());
            }
            res.append("<file name=\"" + path + file.getName() + "\" crc=\"" + FileListGenerator.calculateChecksum(file) + "\" size=\"" + file.length() + "\" mtime=\"" + file.lastModified() + "\"/>\n");
        }
    }

    private static long calculateChecksum(File file) {
        try {
            CRC32 cs = new CRC32();
            cs.reset();
            FileInputStream fis = new FileInputStream(file);
            byte[] buf = new byte[1024];
            int l = 0;
            while ((l = fis.read(buf)) >= 0) {
                cs.update(buf, 0, l);
            }
            fis.close();
            return cs.getValue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    private static void updateVersion() {
        int version = FileListGenerator.getVersion();
        version = version < 0 ? 0 : (version >= 99 ? 0 : ++version);
        System.out.println("Generate new version: " + version);
        FileListGenerator.setVersion(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVersion() {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("update.build"), "utf-8"));
            String line = br.readLine();
            int n = Integer.parseInt(line);
            return n;
        }
        catch (NumberFormatException ex) {
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            int n = 0;
            return n;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVersion(int version) {
        OutputStreamWriter bw = null;
        try {
            bw = new FileWriter(new File("update.build"));
            bw.append(Integer.toString(version));
            bw.flush();
        }
        catch (Exception ex) {
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setListParams(long listCrc, long size, long modified) {
        OutputStreamWriter bw = null;
        try {
            bw = new FileWriter(new File("list.crc"));
            bw.append(Long.toString(listCrc) + " " + Long.toString(size) + " " + modified);
            bw.flush();
        }
        catch (Exception ex) {
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkXML(Set<File> files) throws BadXmlException {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            for (File file : files) {
                if (!file.getAbsolutePath().endsWith(".xml") || file.getName().equals("list.xml")) continue;
                try {
                    dBuilder.parse(file);
                }
                catch (Exception ex) {
                    throw new BadXmlException(file.getCanonicalPath(), ex);
                    return;
                }
            }
        }
        catch (Exception ex) {
            throw new BadXmlException(ex);
        }
    }
}

